/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.matcher;

import dev.mokkery.internal.ArrayUtilsKt;
import dev.mokkery.internal.MultipleMatchersForSingleArgException;
import dev.mokkery.internal.VarargsAmbiguityDetectedException;
import dev.mokkery.internal.matcher.ArgMatchersComposer;
import dev.mokkery.internal.matcher.CompositeVarArgMatcher;
import dev.mokkery.internal.tracing.CallArg;
import dev.mokkery.matcher.ArgMatcher;
import dev.mokkery.matcher.varargs.VarArgMatcher;
import dev.mokkery.matcher.varargs.VarargMatcherMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00040\tH\u0016J.\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00040\tH\u0002J.\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00040\tH\u0002\u00a8\u0006\r"}, d2={"Ldev/mokkery/internal/matcher/ArgMatchersComposerImpl;", "Ldev/mokkery/internal/matcher/ArgMatchersComposer;", "()V", "compose", "Ldev/mokkery/matcher/ArgMatcher;", "", "arg", "Ldev/mokkery/internal/tracing/CallArg;", "matchers", "", "name", "", "composeVarargs", "mokkery-runtime"})
final class ArgMatchersComposerImpl
implements ArgMatchersComposer {
    @Override
    @NotNull
    public ArgMatcher<Object> compose(@NotNull CallArg arg, @NotNull List<? extends ArgMatcher<Object>> matchers) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter(matchers, (String)"matchers");
        return arg.isVararg() ? this.composeVarargs(arg, matchers) : (matchers.isEmpty() ? (ArgMatcher<Object>)new ArgMatcher.Equals<Object>(arg.getValue()) : this.compose(arg.getName(), matchers));
    }

    private final ArgMatcher<Object> compose(String name, List<? extends ArgMatcher<Object>> matchers) {
        List stack = new ArrayList();
        for (ArgMatcher<Object> argMatcher : matchers) {
            if (!(argMatcher instanceof ArgMatcher.Composite)) {
                ((Collection)stack).add(argMatcher);
                continue;
            }
            ArgMatcher.Composite composite = (ArgMatcher.Composite)argMatcher;
            while (!((Collection)stack).isEmpty() && !composite.isFilled()) {
                ArgMatcher matcher = (ArgMatcher)CollectionsKt.removeLast((List)stack);
                ArgMatcher.Composite composeResult = composite.compose(matcher);
                composite = !(composite instanceof CompositeVarArgMatcher) && matcher instanceof VarArgMatcher ? (ArgMatcher.Composite)new VarargMatcherMarker(composeResult) : composeResult;
            }
            composite.assertFilled();
            ((Collection)stack).add(composite);
        }
        ArgMatcher argMatcher = (ArgMatcher)CollectionsKt.singleOrNull((List)stack);
        if (argMatcher == null) {
            throw new MultipleMatchersForSingleArgException(name, stack);
        }
        return argMatcher;
    }

    private final ArgMatcher<Object> composeVarargs(CallArg arg, List<? extends ArgMatcher<Object>> matchers) {
        int expectedMatchersSize;
        ArgMatcher<Object> matcher = this.compose(arg.getName(), (List<? extends ArgMatcher<Object>>)CollectionsKt.plus((Collection)matchers, (Object)new CompositeVarArgMatcher(ArrayUtilsKt.arrayElementType(arg.getValue()), null, 2, null)));
        if (!(matcher instanceof CompositeVarArgMatcher)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int matchersSize = ((CompositeVarArgMatcher)matcher).getMatchers().size();
        List<Object> list = ArrayUtilsKt.asListOrNull(arg.getValue());
        int n = expectedMatchersSize = list != null ? list.size() : 0;
        if (matchersSize != expectedMatchersSize) {
            throw new VarargsAmbiguityDetectedException();
        }
        return matcher;
    }
}

