/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.matcher;

import dev.mokkery.internal.matcher.CallMatcher;
import dev.mokkery.internal.signature.SignatureGenerator;
import dev.mokkery.internal.templating.CallTemplate;
import dev.mokkery.internal.tracing.CallArg;
import dev.mokkery.internal.tracing.CallTrace;
import dev.mokkery.matcher.ArgMatcher;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/mokkery/internal/matcher/CallMatcherImpl;", "Ldev/mokkery/internal/matcher/CallMatcher;", "signatureGenerator", "Ldev/mokkery/internal/signature/SignatureGenerator;", "(Ldev/mokkery/internal/signature/SignatureGenerator;)V", "matches", "", "trace", "Ldev/mokkery/internal/tracing/CallTrace;", "template", "Ldev/mokkery/internal/templating/CallTemplate;", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nCallMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallMatcher.kt\ndev/mokkery/internal/matcher/CallMatcherImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,23:1\n1726#2,3:24\n*S KotlinDebug\n*F\n+ 1 CallMatcher.kt\ndev/mokkery/internal/matcher/CallMatcherImpl\n*L\n20#1:24,3\n*E\n"})
final class CallMatcherImpl
implements CallMatcher {
    @NotNull
    private final SignatureGenerator signatureGenerator;

    public CallMatcherImpl(@NotNull SignatureGenerator signatureGenerator) {
        Intrinsics.checkNotNullParameter((Object)signatureGenerator, (String)"signatureGenerator");
        this.signatureGenerator = signatureGenerator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(@NotNull CallTrace trace, @NotNull CallTemplate template) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        if (!Intrinsics.areEqual((Object)trace.getReceiver(), (Object)template.getReceiver())) return false;
        if (!Intrinsics.areEqual((Object)this.signatureGenerator.generate(trace.getName(), trace.getArgs()), (Object)template.getSignature())) return false;
        Iterable $this$all$iv = trace.getArgs();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            CallArg arg = (CallArg)element$iv;
            boolean bl2 = false;
            ArgMatcher<Object> argMatcher = template.getMatchers().get(arg.getName());
            if (argMatcher == null) return false;
            bl = argMatcher.matches(arg.getValue());
        } while (bl);
        return false;
    }
}

