/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.tracing;

import dev.mokkery.internal.CallContext;
import dev.mokkery.internal.MokkeryToken;
import dev.mokkery.internal.tracing.CallTrace;
import dev.mokkery.internal.tracing.CallTraceClock;
import dev.mokkery.internal.tracing.CallTracingInterceptor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\b\u0002\u0018\u00002\u00020\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\n*\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006\u001d"}, d2={"Ldev/mokkery/internal/tracing/CallTracingInterceptorImpl;", "Ldev/mokkery/internal/tracing/CallTraceClock;", "clock", "<init>", "(Ldev/mokkery/internal/tracing/CallTraceClock;)V", "Ldev/mokkery/internal/CallContext;", "context", "", "interceptCall", "(Ldev/mokkery/internal/CallContext;)Ljava/lang/Object;", "Ldev/mokkery/internal/tracing/CallTrace;", "trace", "", "markVerified", "(Ldev/mokkery/internal/tracing/CallTrace;)V", "reset", "()V", "toTrace", "(Ldev/mokkery/internal/CallContext;)Ldev/mokkery/internal/tracing/CallTrace;", "", "getAll", "()Ljava/util/List;", "all", "Ldev/mokkery/internal/tracing/CallTraceClock;", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getUnverified", "unverified", "mokkery-runtime", "Ldev/mokkery/internal/tracing/CallTracingInterceptor;"})
@SourceDebugExtension(value={"SMAP\nCallTracingInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTracingInterceptor.kt\ndev/mokkery/internal/tracing/CallTracingInterceptorImpl\n+ 2 AtomicFU.kt\nkotlinx/atomicfu/AtomicRef\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n87#2,3:55\n87#2,3:58\n1#3:61\n*S KotlinDebug\n*F\n+ 1 CallTracingInterceptor.kt\ndev/mokkery/internal/tracing/CallTracingInterceptorImpl\n*L\n29#1:55,3\n30#1:58,3\n*E\n"})
final class CallTracingInterceptorImpl
implements CallTracingInterceptor {
    @NotNull
    private final CallTraceClock clock;
    @NotNull
    private volatile /* synthetic */ Object verified$delegate;
    @NotNull
    private volatile /* synthetic */ Object _all$delegate;
    @NotNull
    private final ReentrantLock lock;

    public CallTracingInterceptorImpl(@NotNull CallTraceClock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.verified$delegate = CollectionsKt.emptyList();
        this._all$delegate = CollectionsKt.emptyList();
        this.lock = new ReentrantLock();
    }

    private final List<CallTrace> getVerified() {
        return (List)this.verified$delegate;
    }

    private final void setVerified(List<CallTrace> list) {
        this.verified$delegate = list;
    }

    private final List<CallTrace> get_all() {
        return (List)this._all$delegate;
    }

    private final void set_all(List<CallTrace> list) {
        this._all$delegate = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CallTrace> getUnverified() {
        List list;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            list = CollectionsKt.minus((Iterable)this.get_all(), (Iterable)CollectionsKt.toSet((Iterable)this.getVerified()));
        }
        finally {
            reentrantLock.unlock();
        }
        return list;
    }

    @Override
    @NotNull
    public List<CallTrace> getAll() {
        return this.get_all();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            this.setVerified(CollectionsKt.emptyList());
            this.set_all(CollectionsKt.emptyList());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markVerified(@NotNull CallTrace trace) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            this.setVerified(CollectionsKt.plus((Collection)this.getVerified(), (Object)trace));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Object interceptCall(@NotNull CallContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            this.set_all(CollectionsKt.plus((Collection)this.get_all(), (Object)this.toTrace(context)));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
        return MokkeryToken.CALL_NEXT;
    }

    private final CallTrace toTrace(CallContext $this$toTrace) {
        return new CallTrace($this$toTrace.getSelf().getId(), $this$toTrace.getName(), $this$toTrace.getArgs(), this.clock.nextStamp());
    }

    @Override
    @Nullable
    public Object interceptSuspendCall(@NotNull CallContext context, @NotNull Continuation<Object> $completion) {
        return CallTracingInterceptor.DefaultImpls.interceptSuspendCall(this, context, $completion);
    }
}

