/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.templating;

import dev.mokkery.annotations.DelicateMokkeryApi;
import dev.mokkery.internal.ArrayUtilsKt;
import dev.mokkery.internal.ConcurrentTemplatingException;
import dev.mokkery.internal.MokkerySpyScope;
import dev.mokkery.internal.UtilsKt;
import dev.mokkery.internal.VarargsAmbiguityDetectedException;
import dev.mokkery.internal.answering.AutofillValueKt;
import dev.mokkery.internal.matcher.ArgMatchersComposer;
import dev.mokkery.internal.signature.SignatureGenerator;
import dev.mokkery.internal.templating.CallTemplate;
import dev.mokkery.internal.templating.TemplatingInterceptor;
import dev.mokkery.internal.templating.TemplatingScope;
import dev.mokkery.internal.tracing.CallArg;
import dev.mokkery.matcher.ArgMatcher;
import dev.mokkery.matcher.varargs.VarArgMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u001b\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010 \u001a\u0002H\u001fH\u0016\u00a2\u0006\u0002\u0010!J0\u0010\"\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0#0\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000eH\u0002J\u001c\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020\r2\b\u0010(\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010)\u001a\u0004\u0018\u00010\n2\b\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010*\u001a\u00020\u0019H\u0016J-\u0010+\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u001f0\tH\u0017\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u001dH\u0016J&\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\r\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Ldev/mokkery/internal/templating/TemplatingScopeImpl;", "Ldev/mokkery/internal/templating/TemplatingScope;", "signatureGenerator", "Ldev/mokkery/internal/signature/SignatureGenerator;", "composer", "Ldev/mokkery/internal/matcher/ArgMatchersComposer;", "(Ldev/mokkery/internal/signature/SignatureGenerator;Ldev/mokkery/internal/matcher/ArgMatchersComposer;)V", "currentMatchers", "", "Ldev/mokkery/matcher/ArgMatcher;", "", "matchers", "", "", "", "spies", "", "Ldev/mokkery/internal/MokkerySpyScope;", "getSpies", "()Ljava/util/Set;", "templates", "Ldev/mokkery/internal/templating/CallTemplate;", "getTemplates", "()Ljava/util/List;", "varargGenericMatcherFlag", "", "varargsMatchersCount", "", "clearCurrent", "", "ensureBinding", "T", "obj", "(Ljava/lang/Object;)Ljava/lang/Object;", "flush", "Lkotlin/Pair;", "args", "Ldev/mokkery/internal/tracing/CallArg;", "interceptArg", "name", "arg", "interceptVarargElement", "isSpread", "matches", "argType", "Lkotlin/reflect/KClass;", "matcher", "(Lkotlin/reflect/KClass;Ldev/mokkery/matcher/ArgMatcher;)Ljava/lang/Object;", "release", "saveTemplate", "receiver", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nTemplatingScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplatingScope.kt\ndev/mokkery/internal/templating/TemplatingScopeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Utils.kt\ndev/mokkery/internal/UtilsKt\n*L\n1#1,132:1\n1855#2,2:133\n1864#2,3:136\n1549#2:139\n1620#2,3:140\n8#3:135\n*S KotlinDebug\n*F\n+ 1 TemplatingScope.kt\ndev/mokkery/internal/templating/TemplatingScopeImpl\n*L\n68#1:133,2\n96#1:136,3\n118#1:139\n118#1:140,3\n77#1:135\n*E\n"})
final class TemplatingScopeImpl
implements TemplatingScope {
    @NotNull
    private final SignatureGenerator signatureGenerator;
    @NotNull
    private final ArgMatchersComposer composer;
    @NotNull
    private final List<ArgMatcher<Object>> currentMatchers;
    @NotNull
    private final Map<String, List<ArgMatcher<Object>>> matchers;
    private boolean varargGenericMatcherFlag;
    private int varargsMatchersCount;
    @NotNull
    private final Set<MokkerySpyScope> spies;
    @NotNull
    private final List<CallTemplate> templates;

    public TemplatingScopeImpl(@NotNull SignatureGenerator signatureGenerator, @NotNull ArgMatchersComposer composer) {
        Intrinsics.checkNotNullParameter((Object)signatureGenerator, (String)"signatureGenerator");
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        this.signatureGenerator = signatureGenerator;
        this.composer = composer;
        this.currentMatchers = new ArrayList();
        this.matchers = new LinkedHashMap();
        this.spies = new LinkedHashSet();
        this.templates = new ArrayList();
    }

    @Override
    @NotNull
    public Set<MokkerySpyScope> getSpies() {
        return this.spies;
    }

    @Override
    @NotNull
    public List<CallTemplate> getTemplates() {
        return this.templates;
    }

    @Override
    public <T> T ensureBinding(T obj) {
        if (obj instanceof MokkerySpyScope) {
            TemplatingInterceptor templating = ((MokkerySpyScope)obj).getInterceptor().getTemplating();
            if (templating.isEnabledWith(this)) {
                return obj;
            }
            if (templating.isEnabled()) {
                throw new ConcurrentTemplatingException();
            }
            this.getSpies().add((MokkerySpyScope)obj);
            templating.start(this);
        }
        return obj;
    }

    @Override
    public void release() {
        Iterable $this$forEach$iv = this.getSpies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MokkerySpyScope it = (MokkerySpyScope)element$iv;
            boolean bl = false;
            it.getInterceptor().getTemplating().stop();
        }
        this.getSpies().clear();
    }

    @Override
    @DelicateMokkeryApi
    public <T> T matches(@NotNull KClass<?> argType, @NotNull ArgMatcher<? super T> matcher) {
        Intrinsics.checkNotNullParameter(argType, (String)"argType");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        if (matcher instanceof VarArgMatcher) {
            this.varargGenericMatcherFlag = true;
        }
        ArgMatcher<? super T> $this$unsafeCast$iv = matcher;
        boolean $i$f$unsafeCast = false;
        this.currentMatchers.add((ArgMatcher<Object>)$this$unsafeCast$iv);
        return AutofillValueKt.autofillValue(argType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object interceptVarargElement(@Nullable Object arg, boolean isSpread) {
        List<Object> list;
        if (isSpread) {
            list = ArrayUtilsKt.toListOrNull(arg);
            if (list == null) {
                throw new IllegalStateException(("Expected array for spread operator, but " + arg + " encountered!").toString());
            }
        } else {
            list = CollectionsKt.listOf((Object)arg);
        }
        List<Object> args = list;
        int size = args.size();
        int elementMatchersSize = UtilsKt.subListAfter(this.currentMatchers, this.varargsMatchersCount).size();
        if (this.varargGenericMatcherFlag) {
            this.varargGenericMatcherFlag = false;
            if (elementMatchersSize != size + 1) {
                throw new VarargsAmbiguityDetectedException();
            }
            int n = this.varargsMatchersCount;
            this.varargsMatchersCount = n + 1;
            return arg;
        }
        if (elementMatchersSize != 0 && elementMatchersSize < size) {
            throw new VarargsAmbiguityDetectedException();
        }
        Iterable $this$forEachIndexed$iv = args;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void vararg;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int index = n;
            boolean bl = false;
            ArgMatcher matcher = (ArgMatcher)CollectionsKt.getOrNull(this.currentMatchers, (int)(this.varargsMatchersCount + index));
            if (matcher != null) continue;
            this.currentMatchers.add(new ArgMatcher.Equals<void>(vararg));
        }
        this.varargsMatchersCount += size;
        return arg;
    }

    @Override
    @Nullable
    public Object interceptArg(@NotNull String name, @Nullable Object arg) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.matchers.put(name, CollectionsKt.toMutableList((Collection)this.currentMatchers));
        this.currentMatchers.clear();
        return arg;
    }

    @Override
    public void saveTemplate(@NotNull String receiver, @NotNull String name, @NotNull List<CallArg> args) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        List<Pair<String, ArgMatcher<Object>>> matchers = this.flush(args);
        ((Collection)this.getTemplates()).add(new CallTemplate(receiver, name, this.signatureGenerator.generate(name, args), MapsKt.toMap((Iterable)matchers)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, ArgMatcher<Object>>> flush(List<CallArg> args) {
        void $this$mapTo$iv$iv;
        Map matchersSnapshot = MapsKt.toMutableMap(this.matchers);
        this.clearCurrent();
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CallArg callArg = (CallArg)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list = (List)matchersSnapshot.get(it.getName());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List matchers = list;
            collection.add(TuplesKt.to((Object)it.getName(), this.composer.compose((CallArg)it, matchers)));
        }
        return (List)destination$iv$iv;
    }

    private final void clearCurrent() {
        this.matchers.clear();
        this.varargsMatchersCount = 0;
        this.varargGenericMatcherFlag = false;
        this.currentMatchers.clear();
    }
}

