/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.templating;

import dev.mokkery.annotations.DelicateMokkeryApi;
import dev.mokkery.internal.ArrayUtilsKt;
import dev.mokkery.internal.ConcurrentTemplatingException;
import dev.mokkery.internal.MokkeryInterceptorScope;
import dev.mokkery.internal.MokkerySpyScope;
import dev.mokkery.internal.UtilsKt;
import dev.mokkery.internal.VarargsAmbiguityDetectedException;
import dev.mokkery.internal.answering.AutofillValueKt;
import dev.mokkery.internal.dynamic.MokkeryScopeLookup;
import dev.mokkery.internal.matcher.ArgMatchersComposer;
import dev.mokkery.internal.signature.SignatureGenerator;
import dev.mokkery.internal.templating.CallTemplate;
import dev.mokkery.internal.templating.TemplateData;
import dev.mokkery.internal.templating.TemplatingInterceptor;
import dev.mokkery.internal.templating.TemplatingScope;
import dev.mokkery.internal.tracing.CallArg;
import dev.mokkery.matcher.ArgMatcher;
import dev.mokkery.matcher.varargs.VarArgMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\fH\u0016J0\u0010#\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020&\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0%0$2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0$H\u0002J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001aH\u0002J$\u0010*\u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020&2\b\u0010,\u001a\u0004\u0018\u00010\fH\u0016J$\u0010-\u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\u001a2\b\u0010,\u001a\u0004\u0018\u00010\f2\u0006\u0010.\u001a\u00020\u000eH\u0016J\u0010\u0010/\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u001aH\u0002J-\u00100\u001a\u0002H1\"\u0004\b\u0000\u001012\n\u00102\u001a\u0006\u0012\u0002\b\u0003032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H10\u000bH\u0017\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u00020\u001fH\u0016J&\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020&2\u0006\u0010+\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0$H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Ldev/mokkery/internal/templating/TemplatingScopeImpl;", "Ldev/mokkery/internal/templating/TemplatingScope;", "signatureGenerator", "Ldev/mokkery/internal/signature/SignatureGenerator;", "composer", "Ldev/mokkery/internal/matcher/ArgMatchersComposer;", "scopeLookup", "Ldev/mokkery/internal/dynamic/MokkeryScopeLookup;", "(Ldev/mokkery/internal/signature/SignatureGenerator;Ldev/mokkery/internal/matcher/ArgMatchersComposer;Ldev/mokkery/internal/dynamic/MokkeryScopeLookup;)V", "currentMatchers", "", "Ldev/mokkery/matcher/ArgMatcher;", "", "isReleased", "", "spies", "", "Ldev/mokkery/internal/MokkerySpyScope;", "getSpies", "()Ljava/util/Set;", "templates", "Ldev/mokkery/internal/templating/CallTemplate;", "getTemplates", "()Ljava/util/List;", "tokenToData", "", "", "Ldev/mokkery/internal/templating/TemplateData;", "tokenToObj", "varargGenericMatcherFlag", "clearCurrent", "", "ensureBinding", "token", "obj", "flush", "", "Lkotlin/Pair;", "", "args", "Ldev/mokkery/internal/tracing/CallArg;", "getDataFor", "interceptArg", "name", "arg", "interceptVarargElement", "isSpread", "isTokenDefinitelyNotMocked", "matches", "T", "argType", "Lkotlin/reflect/KClass;", "matcher", "(Lkotlin/reflect/KClass;Ldev/mokkery/matcher/ArgMatcher;)Ljava/lang/Object;", "release", "saveTemplate", "receiver", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nTemplatingScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplatingScope.kt\ndev/mokkery/internal/templating/TemplatingScopeImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Utils.kt\ndev/mokkery/internal/UtilsKt\n*L\n1#1,162:1\n361#2,7:163\n361#2,7:173\n483#2,7:183\n361#2,7:194\n1855#3,2:170\n1864#3,3:180\n1549#3:190\n1620#3,3:191\n8#4:172\n*S KotlinDebug\n*F\n+ 1 TemplatingScope.kt\ndev/mokkery/internal/templating/TemplatingScopeImpl\n*L\n63#1:163,7\n94#1:173,7\n133#1:183,7\n150#1:194,7\n77#1:170,2\n109#1:180,3\n137#1:190\n137#1:191,3\n87#1:172\n*E\n"})
final class TemplatingScopeImpl
implements TemplatingScope {
    @NotNull
    private final SignatureGenerator signatureGenerator;
    @NotNull
    private final ArgMatchersComposer composer;
    @NotNull
    private final MokkeryScopeLookup scopeLookup;
    private boolean isReleased;
    @NotNull
    private final List<ArgMatcher<Object>> currentMatchers;
    private boolean varargGenericMatcherFlag;
    @NotNull
    private final Map<Integer, Object> tokenToObj;
    @NotNull
    private final Map<Integer, TemplateData> tokenToData;
    @NotNull
    private final Set<MokkerySpyScope> spies;
    @NotNull
    private final List<CallTemplate> templates;

    public TemplatingScopeImpl(@NotNull SignatureGenerator signatureGenerator, @NotNull ArgMatchersComposer composer, @NotNull MokkeryScopeLookup scopeLookup) {
        Intrinsics.checkNotNullParameter((Object)signatureGenerator, (String)"signatureGenerator");
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)scopeLookup, (String)"scopeLookup");
        this.signatureGenerator = signatureGenerator;
        this.composer = composer;
        this.scopeLookup = scopeLookup;
        this.currentMatchers = new ArrayList();
        this.tokenToObj = new LinkedHashMap();
        this.tokenToData = new LinkedHashMap();
        this.spies = new LinkedHashSet();
        this.templates = new ArrayList();
    }

    @Override
    @NotNull
    public Set<MokkerySpyScope> getSpies() {
        return this.spies;
    }

    @Override
    @NotNull
    public List<CallTemplate> getTemplates() {
        return this.templates;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void ensureBinding(int token, @Nullable Object obj) {
        if (this.isReleased) {
            return;
        }
        Integer n = token;
        this.tokenToObj.put(n, obj);
        MokkeryInterceptorScope scope = this.scopeLookup.resolve(obj);
        if (scope instanceof MokkerySpyScope) {
            void $this$getOrPut$iv;
            TemplatingInterceptor templating = ((MokkerySpyScope)scope).getInterceptor().getTemplating();
            Map<Integer, TemplateData> map = this.tokenToData;
            Integer key$iv = token;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                TemplateData answer$iv = new TemplateData(null, 0, 3, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
            }
            if (templating.isEnabledWith(this)) {
                return;
            }
            if (templating.isEnabled()) {
                throw new ConcurrentTemplatingException();
            }
            this.getSpies().add((MokkerySpyScope)scope);
            templating.start(this);
        }
    }

    @Override
    public void release() {
        this.isReleased = true;
        Iterable $this$forEach$iv = this.getSpies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MokkerySpyScope it = (MokkerySpyScope)element$iv;
            boolean bl = false;
            it.getInterceptor().getTemplating().stop();
        }
        this.getSpies().clear();
    }

    @Override
    @DelicateMokkeryApi
    public <T> T matches(@NotNull KClass<?> argType, @NotNull ArgMatcher<? super T> matcher) {
        Intrinsics.checkNotNullParameter(argType, (String)"argType");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        if (this.isReleased) {
            return AutofillValueKt.autofillValue(argType);
        }
        if (matcher instanceof VarArgMatcher) {
            this.varargGenericMatcherFlag = true;
        }
        ArgMatcher<? super T> $this$unsafeCast$iv = matcher;
        boolean $i$f$unsafeCast = false;
        this.currentMatchers.add((ArgMatcher<Object>)$this$unsafeCast$iv);
        return AutofillValueKt.autofillValue(argType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object interceptVarargElement(int token, @Nullable Object arg, boolean isSpread) {
        List<Object> list;
        Object object;
        void $this$getOrPut$iv;
        if (this.isReleased) {
            return arg;
        }
        if (this.isTokenDefinitelyNotMocked(token)) {
            return arg;
        }
        Map<Integer, TemplateData> map = this.tokenToData;
        Integer key$iv = token;
        boolean $i$f$getOrPut = false;
        Object value$iv2 = $this$getOrPut$iv.get(key$iv);
        if (value$iv2 == null) {
            boolean bl = false;
            TemplateData answer$iv = new TemplateData(null, 0, 3, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        TemplateData data = (TemplateData)object;
        if (isSpread) {
            list = ArrayUtilsKt.toListOrNull(arg);
            if (list == null) {
                throw new IllegalStateException(("Expected array for spread operator, but " + arg + " encountered!").toString());
            }
        } else {
            list = CollectionsKt.listOf((Object)arg);
        }
        List<Object> args = list;
        int size = args.size();
        int elementMatchersSize = UtilsKt.subListAfter(this.currentMatchers, data.getVarargsMatchersCount()).size();
        if (this.varargGenericMatcherFlag) {
            this.varargGenericMatcherFlag = false;
            if (elementMatchersSize != size + 1) {
                throw new VarargsAmbiguityDetectedException();
            }
            int value$iv2 = data.getVarargsMatchersCount();
            data.setVarargsMatchersCount(value$iv2 + 1);
            return arg;
        }
        if (elementMatchersSize != 0 && elementMatchersSize < size) {
            throw new VarargsAmbiguityDetectedException();
        }
        Iterable $this$forEachIndexed$iv = args;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void vararg;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int index = n;
            boolean bl = false;
            ArgMatcher matcher = (ArgMatcher)CollectionsKt.getOrNull(this.currentMatchers, (int)(data.getVarargsMatchersCount() + index));
            if (matcher != null) continue;
            this.currentMatchers.add(new ArgMatcher.Equals<void>(vararg));
        }
        data.setVarargsMatchersCount(data.getVarargsMatchersCount() + size);
        return arg;
    }

    @Override
    @Nullable
    public Object interceptArg(int token, @NotNull String name, @Nullable Object arg) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.isReleased) {
            return arg;
        }
        if (this.isTokenDefinitelyNotMocked(token)) {
            return arg;
        }
        TemplateData data = this.getDataFor(token);
        data.getMatchers().put(name, CollectionsKt.toMutableList((Collection)this.currentMatchers));
        this.currentMatchers.clear();
        return arg;
    }

    @Override
    public void saveTemplate(@NotNull String receiver, @NotNull String name, @NotNull List<CallArg> args) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (this.isReleased) {
            return;
        }
        List<Pair<String, ArgMatcher<Object>>> matchers = this.flush(args);
        ((Collection)this.getTemplates()).add(new CallTemplate(receiver, name, this.signatureGenerator.generate(name, args), MapsKt.toMap((Iterable)matchers)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, ArgMatcher<Object>>> flush(List<CallArg> args) {
        Map<Integer, Object> $this$filterValues$iv = this.tokenToObj;
        boolean $i$f$filterValues = false;
        LinkedHashMap<Integer, Object> result$iv = new LinkedHashMap<Integer, Object>();
        for (Map.Entry<Integer, Object> entry : $this$filterValues$iv.entrySet()) {
            Object it = entry.getValue();
            boolean bl = false;
            if (!(this.scopeLookup.resolve(it) != null)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        int token = ((Number)CollectionsKt.first((Iterable)((Map)result$iv).keySet())).intValue();
        Map<String, List<ArgMatcher<Object>>> registeredMatchers = this.getDataFor(token).getMatchers();
        Map matchersSnapshot = MapsKt.toMutableMap(registeredMatchers);
        this.clearCurrent();
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable) {
            void it;
            CallArg callArg = (CallArg)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list = (List)matchersSnapshot.get(it.getName());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List matchers = list;
            collection.add(TuplesKt.to((Object)it.getName(), this.composer.compose((CallArg)it, matchers)));
        }
        return (List)destination$iv$iv;
    }

    private final void clearCurrent() {
        this.tokenToData.clear();
        this.tokenToObj.clear();
        this.varargGenericMatcherFlag = false;
        this.currentMatchers.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final TemplateData getDataFor(int token) {
        Object object;
        void $this$getOrPut$iv;
        Map<Integer, TemplateData> map = this.tokenToData;
        Integer key$iv = token;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            TemplateData answer$iv = new TemplateData(null, 0, 3, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (TemplateData)object;
    }

    private final boolean isTokenDefinitelyNotMocked(int token) {
        Object obj = this.tokenToObj.get(token);
        return obj != null && this.scopeLookup.resolve(obj) == null;
    }
}

