/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.verify;

import dev.mokkery.internal.templating.CallTemplate;
import dev.mokkery.internal.tracing.CallTrace;
import dev.mokkery.internal.tracing.CallTraceKt;
import dev.mokkery.internal.verify.ExhaustiveOrderVerifier;
import dev.mokkery.internal.verify.Verifier;
import dev.mokkery.internal.verify.VerifierKt;
import java.util.Comparator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004H\u0016\u00a8\u0006\t"}, d2={"Ldev/mokkery/internal/verify/ExhaustiveOrderVerifier;", "Ldev/mokkery/internal/verify/Verifier;", "()V", "verify", "", "Ldev/mokkery/internal/tracing/CallTrace;", "callTraces", "callTemplates", "Ldev/mokkery/internal/templating/CallTemplate;", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nExhaustiveOrderVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExhaustiveOrderVerifier.kt\ndev/mokkery/internal/verify/ExhaustiveOrderVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,21:1\n1045#2:22\n1855#2,2:23\n*S KotlinDebug\n*F\n+ 1 ExhaustiveOrderVerifier.kt\ndev/mokkery/internal/verify/ExhaustiveOrderVerifier\n*L\n9#1:22\n13#1:23,2\n*E\n"})
public final class ExhaustiveOrderVerifier
implements Verifier {
    @NotNull
    public static final ExhaustiveOrderVerifier INSTANCE = new ExhaustiveOrderVerifier();

    private ExhaustiveOrderVerifier() {
    }

    @Override
    @NotNull
    public List<CallTrace> verify(@NotNull List<CallTrace> callTraces, @NotNull List<CallTemplate> callTemplates) {
        Intrinsics.checkNotNullParameter(callTraces, (String)"callTraces");
        Intrinsics.checkNotNullParameter(callTemplates, (String)"callTemplates");
        Iterable $this$sortedBy$iv = callTraces;
        boolean $i$f$sortedBy = false;
        List sortedTracks = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CallTrace it = (CallTrace)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getOrderStamp());
                it = (CallTrace)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getOrderStamp()));
            }
        });
        if (callTemplates.size() != callTraces.size()) {
            VerifierKt.failAssertion(callTraces, callTemplates, (Function0<String>)((Function0)verify.1.INSTANCE));
            throw new KotlinNothingValueException();
        }
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)sortedTracks, (Iterable)callTemplates);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CallTemplate template;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            CallTrace trace = (CallTrace)pair.component1();
            if (!CallTraceKt.doesNotMatch(trace, template = (CallTemplate)pair.component2())) continue;
            VerifierKt.failAssertion(callTraces, callTemplates, (Function0<String>)((Function0)verify.2.1.INSTANCE));
            throw new KotlinNothingValueException();
        }
        return callTraces;
    }
}

