/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.templating;

import dev.mokkery.internal.ArrayUtilsKt;
import dev.mokkery.internal.ConcurrentTemplatingException;
import dev.mokkery.internal.MokkerySpyScope;
import dev.mokkery.internal.MultipleMatchersForSingleArgException;
import dev.mokkery.internal.MultipleVarargGenericMatchersException;
import dev.mokkery.internal.UtilsKt;
import dev.mokkery.internal.VarargsAmbiguityDetectedException;
import dev.mokkery.internal.matcher.MergedVarArgMatcher;
import dev.mokkery.internal.templating.CallTemplate;
import dev.mokkery.internal.templating.TemplatingInterceptor;
import dev.mokkery.internal.templating.TemplatingScope;
import dev.mokkery.internal.tracing.CallArg;
import dev.mokkery.matcher.ArgMatcher;
import dev.mokkery.matcher.varargs.VarArgMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u001b\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u001c\u001a\u0002H\u001bH\u0016\u00a2\u0006\u0002\u0010\u001dJ0\u0010\u001e\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00050\u001f0\n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\nH\u0002J\u001c\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010#\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010\u0006H\u0016J\u0014\u0010%\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010&\u001a\u00020\u00192\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0016J\b\u0010(\u001a\u00020\u0019H\u0016J&\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\nH\u0016J0\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010$\u001a\u00020!2\u0016\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00050\nH\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00050\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ldev/mokkery/internal/templating/TemplatingScopeImpl;", "Ldev/mokkery/internal/templating/TemplatingScope;", "()V", "currentMatchers", "", "Ldev/mokkery/matcher/ArgMatcher;", "", "matchers", "", "", "", "spies", "", "Ldev/mokkery/internal/MokkerySpyScope;", "getSpies", "()Ljava/util/Set;", "templates", "Ldev/mokkery/internal/templating/CallTemplate;", "getTemplates", "()Ljava/util/List;", "varargGenericMatcherFlag", "", "varargsMatchersCount", "", "clearCurrent", "", "ensureBinding", "T", "obj", "(Ljava/lang/Object;)Ljava/lang/Object;", "flush", "Lkotlin/Pair;", "args", "Ldev/mokkery/internal/tracing/CallArg;", "interceptArg", "name", "arg", "interceptVarargElement", "registerMatcher", "matcher", "release", "saveTemplate", "receiver", "varargMatcher", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nTemplatingScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplatingScope.kt\ndev/mokkery/internal/templating/TemplatingScopeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1855#2,2:140\n1549#2:142\n1620#2,3:143\n1864#2,3:146\n*S KotlinDebug\n*F\n+ 1 TemplatingScope.kt\ndev/mokkery/internal/templating/TemplatingScopeImpl\n*L\n62#1:140,2\n105#1:142\n105#1:143,3\n120#1:146,3\n*E\n"})
final class TemplatingScopeImpl
implements TemplatingScope {
    @NotNull
    private final List<ArgMatcher<Object>> currentMatchers = new ArrayList();
    @NotNull
    private final Map<String, List<ArgMatcher<Object>>> matchers = new LinkedHashMap();
    private boolean varargGenericMatcherFlag;
    private int varargsMatchersCount;
    @NotNull
    private final Set<MokkerySpyScope> spies = new LinkedHashSet();
    @NotNull
    private final List<CallTemplate> templates = new ArrayList();

    @Override
    @NotNull
    public Set<MokkerySpyScope> getSpies() {
        return this.spies;
    }

    @Override
    @NotNull
    public List<CallTemplate> getTemplates() {
        return this.templates;
    }

    @Override
    public <T> T ensureBinding(T obj) {
        if (obj instanceof MokkerySpyScope) {
            TemplatingInterceptor templating = ((MokkerySpyScope)obj).getInterceptor().getTemplating();
            if (templating.isEnabledWith(this)) {
                return obj;
            }
            if (templating.isEnabled()) {
                throw new ConcurrentTemplatingException();
            }
            this.getSpies().add((MokkerySpyScope)obj);
            templating.start(this);
        }
        return obj;
    }

    @Override
    public void release() {
        Iterable $this$forEach$iv = this.getSpies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MokkerySpyScope it = (MokkerySpyScope)element$iv;
            boolean bl = false;
            it.getInterceptor().getTemplating().stop();
        }
        this.getSpies().clear();
    }

    @Override
    public void registerMatcher(@NotNull ArgMatcher<Object> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        if (matcher instanceof VarArgMatcher) {
            this.varargGenericMatcherFlag = true;
        }
        this.currentMatchers.add(matcher);
    }

    @Override
    @Nullable
    public Object interceptVarargElement(@Nullable Object arg) {
        List<Object> list = ArrayUtilsKt.toListOrNull(arg);
        int size = list != null ? list.size() : 1;
        int elementMatchersSize = UtilsKt.subListAfter(this.currentMatchers, this.varargsMatchersCount).size();
        if (this.varargGenericMatcherFlag) {
            this.varargGenericMatcherFlag = false;
            if (elementMatchersSize != size + 1) {
                throw new VarargsAmbiguityDetectedException();
            }
            int n = this.varargsMatchersCount;
            this.varargsMatchersCount = n + 1;
            return arg;
        }
        if (elementMatchersSize != 0 && elementMatchersSize != size) {
            throw new VarargsAmbiguityDetectedException();
        }
        for (int index = 0; index < size; ++index) {
            ArgMatcher matcher = (ArgMatcher)CollectionsKt.getOrNull(this.currentMatchers, (int)(this.varargsMatchersCount + index));
            if (matcher != null) continue;
            this.currentMatchers.add(null);
        }
        this.varargsMatchersCount += size;
        return arg;
    }

    @Override
    @Nullable
    public Object interceptArg(@NotNull String name, @Nullable Object arg) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.matchers.put(name, CollectionsKt.toMutableList((Collection)this.currentMatchers));
        this.currentMatchers.clear();
        return arg;
    }

    @Override
    public void saveTemplate(@NotNull String receiver, @NotNull String name, @NotNull List<CallArg> args) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        List<Pair<String, ArgMatcher<Object>>> matchers = this.flush(args);
        ((Collection)this.getTemplates()).add(new CallTemplate(receiver, name, UtilsKt.generateSignature(name, args), MapsKt.toMap((Iterable)matchers)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, ArgMatcher<Object>>> flush(List<CallArg> args) {
        void $this$mapTo$iv$iv;
        Map matchersSnapshot = MapsKt.toMutableMap(this.matchers);
        this.clearCurrent();
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair;
            void it;
            CallArg callArg = (CallArg)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list = (List)matchersSnapshot.get(it.getName());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List matchers = list;
            if (!it.isVararg() && matchers.size() > 1) {
                throw new MultipleMatchersForSingleArgException(it.getName(), matchers);
            }
            if (!it.isVararg()) {
                String string = it.getName();
                ArgMatcher argMatcher = (ArgMatcher)CollectionsKt.singleOrNull((List)matchers);
                if (argMatcher == null) {
                    argMatcher = new ArgMatcher.Equals<Object>(it.getValue());
                }
                pair = TuplesKt.to((Object)string, (Object)argMatcher);
            } else {
                pair = TuplesKt.to((Object)it.getName(), this.varargMatcher((CallArg)it, matchers));
            }
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final ArgMatcher<Object> varargMatcher(CallArg arg, List<? extends ArgMatcher<Object>> matchers) {
        List<Object> list = ArrayUtilsKt.toListOrNull(arg.getValue());
        if (list == null) {
            throw new IllegalStateException("Unexpected vararg param!".toString());
        }
        List<Object> varArgs = list;
        List before = new ArrayList();
        Object wildcardMatcher = null;
        List after = new ArrayList();
        Iterable $this$forEachIndexed$iv = matchers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void matcher;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ArgMatcher argMatcher = (ArgMatcher)item$iv;
            int index = n;
            boolean bl = false;
            if (wildcardMatcher != null && matcher instanceof VarArgMatcher) {
                throw new MultipleVarargGenericMatchersException();
            }
            if (matcher instanceof VarArgMatcher) {
                wildcardMatcher = matcher;
                continue;
            }
            if (wildcardMatcher != null) {
                ArgMatcher argMatcher2 = matcher;
                if (argMatcher2 == null) {
                    argMatcher2 = new ArgMatcher.Equals<Object>(varArgs.get(index - 1));
                }
                after.add(argMatcher2);
                continue;
            }
            ArgMatcher argMatcher3 = matcher;
            if (argMatcher3 == null) {
                argMatcher3 = new ArgMatcher.Equals<Object>(varArgs.get(index));
            }
            before.add(argMatcher3);
        }
        return new MergedVarArgMatcher(ArrayUtilsKt.arrayElementType(arg), before, wildcardMatcher, after);
    }

    private final void clearCurrent() {
        this.matchers.clear();
        this.varargsMatchersCount = 0;
        this.varargGenericMatcherFlag = false;
        this.currentMatchers.clear();
    }
}

