/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.debug;

import dev.mokkery.debug.HierarchicalStringBuilder;
import dev.mokkery.debug.JsonLikeStringBuilder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/mokkery/debug/JsonLikeStringBuilder;", "Ldev/mokkery/debug/HierarchicalStringBuilder;", "()V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "", "nestedSectionCounter", "", "build", "buildIndent", "i", "endSection", "", "line", "startSection", "headline", "mokkery-runtime"})
final class JsonLikeStringBuilder
implements HierarchicalStringBuilder {
    @NotNull
    private final StringBuilder builder = new StringBuilder();
    @NotNull
    private String indent = "";
    private int nestedSectionCounter;

    @Override
    public void startSection(@NotNull String headline) {
        Intrinsics.checkNotNullParameter((Object)headline, (String)"headline");
        this.line(headline + " {");
        int n = this.nestedSectionCounter;
        this.nestedSectionCounter = n + 1;
        this.indent = this.buildIndent(this.nestedSectionCounter);
    }

    @Override
    public void line(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.builder.append(this.indent);
        this.builder.append(line);
        Intrinsics.checkNotNullExpressionValue((Object)this.builder.append('\n'), (String)"append('\\n')");
    }

    @Override
    public void endSection() {
        int n = this.nestedSectionCounter;
        this.nestedSectionCounter = n + -1;
        this.indent = this.buildIndent(this.nestedSectionCounter);
        this.line("}");
    }

    @Override
    @NotNull
    public String build() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final String buildIndent(int i) {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence((Function0)buildIndent.1.INSTANCE), (int)i), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }
}

