/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.answering;

import dev.mokkery.MockMode;
import dev.mokkery.answering.Answer;
import dev.mokkery.answering.FunctionScope;
import dev.mokkery.internal.CallContext;
import dev.mokkery.internal.CallNotMockedException;
import dev.mokkery.internal.ConcurrentTemplatingException;
import dev.mokkery.internal.MokkeryInterceptorScope;
import dev.mokkery.internal.answering.AnsweringInterceptor;
import dev.mokkery.internal.matcher.CallMatcher;
import dev.mokkery.internal.templating.CallTemplate;
import dev.mokkery.internal.tracing.CallArg;
import dev.mokkery.internal.tracing.CallTrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\b\u0002\u0018\u00002\u00020%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\r\u001a\u00020\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J#\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0013\u0010 \u001a\u00020\u001f*\u00020\u0007H\u0002\u00a2\u0006\u0004\b \u0010!R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\"R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010#\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Ldev/mokkery/internal/answering/AnsweringInterceptorImpl;", "Ldev/mokkery/MockMode;", "mockMode", "Ldev/mokkery/internal/matcher/CallMatcher;", "callMatcher", "<init>", "(Ldev/mokkery/MockMode;Ldev/mokkery/internal/matcher/CallMatcher;)V", "Ldev/mokkery/internal/CallContext;", "context", "Ldev/mokkery/answering/Answer;", "findAnswerFor", "(Ldev/mokkery/internal/CallContext;)Ldev/mokkery/answering/Answer;", "Ldev/mokkery/internal/tracing/CallTrace;", "trace", "Lkotlin/reflect/KClass;", "returnType", "handleMissingAnswer", "(Ldev/mokkery/internal/tracing/CallTrace;Lkotlin/reflect/KClass;)Ldev/mokkery/answering/Answer;", "", "interceptCall", "(Ldev/mokkery/internal/CallContext;)Ljava/lang/Object;", "interceptSuspendCall", "(Ldev/mokkery/internal/CallContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "reset", "()V", "Ldev/mokkery/internal/templating/CallTemplate;", "template", "answer", "setup", "(Ldev/mokkery/internal/templating/CallTemplate;Ldev/mokkery/answering/Answer;)V", "Ldev/mokkery/answering/FunctionScope;", "toFunctionScope", "(Ldev/mokkery/internal/CallContext;)Ldev/mokkery/answering/FunctionScope;", "Ldev/mokkery/internal/matcher/CallMatcher;", "Ldev/mokkery/MockMode;", "mokkery-runtime", "Ldev/mokkery/internal/answering/AnsweringInterceptor;"})
@SourceDebugExtension(value={"SMAP\nAnsweringInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnsweringInterceptor.kt\ndev/mokkery/internal/answering/AnsweringInterceptorImpl\n+ 2 AtomicFU.kt\nkotlinx/atomicfu/AtomicBoolean\n+ 3 AtomicFU.kt\nkotlinx/atomicfu/AtomicRef\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n138#2,3:75\n87#3,3:78\n1#4:81\n1549#5:82\n1620#5,3:83\n*S KotlinDebug\n*F\n+ 1 AnsweringInterceptor.kt\ndev/mokkery/internal/answering/AnsweringInterceptorImpl\n*L\n33#1:75,3\n34#1:78,3\n72#1:82\n72#1:83,3\n*E\n"})
final class AnsweringInterceptorImpl
implements AnsweringInterceptor {
    @NotNull
    private final MockMode mockMode;
    @NotNull
    private final CallMatcher callMatcher;
    @NotNull
    private volatile /* synthetic */ int isSetup$delegate;
    @NotNull
    private volatile /* synthetic */ Object answers$delegate;

    public AnsweringInterceptorImpl(@NotNull MockMode mockMode, @NotNull CallMatcher callMatcher) {
        Intrinsics.checkNotNullParameter((Object)mockMode, (String)"mockMode");
        Intrinsics.checkNotNullParameter((Object)callMatcher, (String)"callMatcher");
        this.mockMode = mockMode;
        this.callMatcher = callMatcher;
        this.isSetup$delegate = 0;
        this.answers$delegate = new LinkedHashMap();
    }

    private final boolean isSetup() {
        return this.isSetup$delegate != 0;
    }

    private final void setSetup(boolean bl) {
        this.isSetup$delegate = bl ? 1 : 0;
    }

    private final LinkedHashMap<CallTemplate, Answer<?>> getAnswers() {
        return (LinkedHashMap)this.answers$delegate;
    }

    private final void setAnswers(LinkedHashMap<CallTemplate, Answer<?>> linkedHashMap) {
        this.answers$delegate = linkedHashMap;
    }

    @Override
    public void setup(@NotNull CallTemplate template, @NotNull Answer<?> answer) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(answer, (String)"answer");
        this.setSetup(true);
        Map map = this.getAnswers();
        Pair pair = TuplesKt.to((Object)template, answer);
        map.put(pair.getFirst(), pair.getSecond());
        this.setSetup(false);
    }

    @Override
    public void reset() {
        this.setAnswers(new LinkedHashMap());
    }

    @Override
    @Nullable
    public Object interceptCall(@NotNull CallContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isSetup()) {
            throw new ConcurrentTemplatingException();
        }
        return this.findAnswerFor(context).call(this.toFunctionScope(context));
    }

    @Override
    @Nullable
    public Object interceptSuspendCall(@NotNull CallContext context, @NotNull Continuation<Object> $completion) {
        if (this.isSetup()) {
            throw new ConcurrentTemplatingException();
        }
        return this.findAnswerFor(context).callSuspend(this.toFunctionScope(context), $completion);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Answer<?> findAnswerFor(CallContext context) {
        Answer answer;
        CallTrace trace = new CallTrace(context.getSelf().getId(), context.getName(), context.getArgs(), 0L);
        LinkedHashMap<CallTemplate, Answer<?>> answers = this.getAnswers();
        Set<CallTemplate> set = answers.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"answers\n            .keys");
        Iterable iterable = set;
        Object var7_5 = null;
        for (Object t : iterable) {
            CallTemplate it = (CallTemplate)t;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.callMatcher.matches(trace, it)) continue;
            var7_5 = t;
        }
        CallTemplate callTemplate = var7_5;
        if (callTemplate != null) {
            CallTemplate it = callTemplate;
            boolean bl = false;
            Answer answer2 = (Answer)MapsKt.getValue((Map)answers, (Object)it);
            if (answer2 != null) {
                answer = answer2;
                return answer;
            }
        }
        answer = this.handleMissingAnswer(trace, context.getReturnType());
        return answer;
    }

    private final Answer<?> handleMissingAnswer(CallTrace trace, KClass<?> returnType) {
        Answer answer;
        if (this.mockMode == MockMode.autofill) {
            answer = Answer.Autofill.INSTANCE;
        } else if (this.mockMode == MockMode.autoUnit && Intrinsics.areEqual(returnType, (Object)Reflection.getOrCreateKotlinClass(Unit.class))) {
            answer = new Answer.Const<Unit>(Unit.INSTANCE);
        } else {
            throw new CallNotMockedException(trace.toString());
        }
        return answer;
    }

    /*
     * WARNING - void declaration
     */
    private final FunctionScope toFunctionScope(CallContext $this$toFunctionScope) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $this$toFunctionScope.getArgs();
        KClass<?> kClass = $this$toFunctionScope.getReturnType();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            CallArg callArg = (CallArg)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        MokkeryInterceptorScope mokkeryInterceptorScope = $this$toFunctionScope.getSelf();
        List list = (List)destination$iv$iv;
        KClass<?> kClass2 = kClass;
        return new FunctionScope(kClass2, list, mokkeryInterceptorScope);
    }
}

