/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.answering;

import dev.mokkery.MockMode;
import dev.mokkery.answering.Answer;
import dev.mokkery.answering.FunctionScope;
import dev.mokkery.internal.CallNotMockedException;
import dev.mokkery.internal.ConcurrentTemplatingException;
import dev.mokkery.internal.answering.AnsweringInterceptor;
import dev.mokkery.internal.templating.CallTemplate;
import dev.mokkery.internal.tracing.CallArg;
import dev.mokkery.internal.tracing.CallTrace;
import dev.mokkery.internal.tracing.CallTraceKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\b\u0002\u0018\u00002\u00020&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J5\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0007\u001a\u00020\u00012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0011\u001a\u00020\u00102\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J9\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u00012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0015\"\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J=\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u00012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0015\"\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ#\u0010!\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001e2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\rH\u0016\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010#R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010$\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Ldev/mokkery/internal/answering/AnsweringInterceptorImpl;", "", "receiver", "Ldev/mokkery/MockMode;", "mockMode", "<init>", "(Ljava/lang/String;Ldev/mokkery/MockMode;)V", "signature", "Lkotlin/reflect/KClass;", "returnType", "", "Ldev/mokkery/internal/tracing/CallArg;", "args", "Ldev/mokkery/answering/Answer;", "find", "(Ljava/lang/String;Lkotlin/reflect/KClass;Ljava/util/List;)Ldev/mokkery/answering/Answer;", "Ldev/mokkery/internal/tracing/CallTrace;", "trace", "handleMissingAnswer", "(Ldev/mokkery/internal/tracing/CallTrace;Lkotlin/reflect/KClass;)Ldev/mokkery/answering/Answer;", "name", "", "", "interceptCall", "(Ljava/lang/String;Lkotlin/reflect/KClass;[Ldev/mokkery/internal/tracing/CallArg;)Ljava/lang/Object;", "interceptSuspendCall", "(Ljava/lang/String;Lkotlin/reflect/KClass;[Ldev/mokkery/internal/tracing/CallArg;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "reset", "()V", "Ldev/mokkery/internal/templating/CallTemplate;", "template", "answer", "setup", "(Ldev/mokkery/internal/templating/CallTemplate;Ldev/mokkery/answering/Answer;)V", "Ldev/mokkery/MockMode;", "Ljava/lang/String;", "mokkery-runtime", "Ldev/mokkery/internal/answering/AnsweringInterceptor;"})
@SourceDebugExtension(value={"SMAP\nAnsweringInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnsweringInterceptor.kt\ndev/mokkery/internal/answering/AnsweringInterceptorImpl\n+ 2 AtomicFU.kt\nkotlinx/atomicfu/AtomicBoolean\n+ 3 AtomicFU.kt\nkotlinx/atomicfu/AtomicRef\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n138#2,3:74\n87#3,3:77\n1549#4:80\n1620#4,3:81\n1549#4:84\n1620#4,3:85\n1#5:88\n*S KotlinDebug\n*F\n+ 1 AnsweringInterceptor.kt\ndev/mokkery/internal/answering/AnsweringInterceptorImpl\n*L\n32#1:74,3\n33#1:77,3\n48#1:80\n48#1:81,3\n54#1:84\n54#1:85,3\n*E\n"})
final class AnsweringInterceptorImpl
implements AnsweringInterceptor {
    @NotNull
    private final String receiver;
    @NotNull
    private final MockMode mockMode;
    @NotNull
    private volatile /* synthetic */ int isSetup$delegate;
    @NotNull
    private volatile /* synthetic */ Object answers$delegate;

    public AnsweringInterceptorImpl(@NotNull String receiver, @NotNull MockMode mockMode) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)mockMode, (String)"mockMode");
        this.receiver = receiver;
        this.mockMode = mockMode;
        this.isSetup$delegate = 0;
        this.answers$delegate = new LinkedHashMap();
    }

    private final boolean isSetup() {
        return this.isSetup$delegate != 0;
    }

    private final void setSetup(boolean bl) {
        this.isSetup$delegate = bl ? 1 : 0;
    }

    private final LinkedHashMap<CallTemplate, Answer<?>> getAnswers() {
        return (LinkedHashMap)this.answers$delegate;
    }

    private final void setAnswers(LinkedHashMap<CallTemplate, Answer<?>> linkedHashMap) {
        this.answers$delegate = linkedHashMap;
    }

    @Override
    public void setup(@NotNull CallTemplate template, @NotNull Answer<?> answer) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(answer, (String)"answer");
        this.setSetup(true);
        Map map = this.getAnswers();
        Pair pair = TuplesKt.to((Object)template, answer);
        map.put(pair.getFirst(), pair.getSecond());
        this.setSetup(false);
    }

    @Override
    public void reset() {
        this.setAnswers(new LinkedHashMap());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object interceptCall(@NotNull String name, @NotNull KClass<?> returnType, CallArg ... args) {
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (this.isSetup()) {
            throw new ConcurrentTemplatingException();
        }
        List argsList = ArraysKt.toList((Object[])args);
        Iterable iterable = argsList;
        KClass<?> kClass = returnType;
        Answer<?> answer = this.find(name, returnType, argsList);
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CallArg callArg = (CallArg)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        KClass<?> kClass2 = kClass;
        return answer.call(new FunctionScope(kClass2, list));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object interceptSuspendCall(@NotNull String name, @NotNull KClass<?> returnType, @NotNull CallArg[] args, @NotNull Continuation<Object> $completion) {
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.isSetup()) {
            throw new ConcurrentTemplatingException();
        }
        List argsList = ArraysKt.toList((Object[])args);
        Iterable iterable = argsList;
        KClass<?> kClass = returnType;
        Answer<?> answer = this.find(name, returnType, argsList);
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CallArg callArg = (CallArg)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        KClass<?> kClass2 = kClass;
        return answer.callSuspend(new FunctionScope(kClass2, list), $completion);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Answer<?> find(String signature2, KClass<?> returnType, List<CallArg> args) {
        Answer answer;
        CallTrace trace = new CallTrace(this.receiver, signature2, args, 0L);
        LinkedHashMap<CallTemplate, Answer<?>> answers = this.getAnswers();
        Set<CallTemplate> set = answers.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable iterable = set;
        Object var9_7 = null;
        for (Object t : iterable) {
            CallTemplate it = (CallTemplate)t;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!CallTraceKt.matches(trace, it)) continue;
            var9_7 = t;
        }
        CallTemplate callTemplate = var9_7;
        if (callTemplate != null) {
            CallTemplate it = callTemplate;
            boolean bl = false;
            Answer answer2 = (Answer)MapsKt.getValue((Map)answers, (Object)it);
            if (answer2 != null) {
                answer = answer2;
                return answer;
            }
        }
        answer = this.handleMissingAnswer(trace, returnType);
        return answer;
    }

    private final Answer<?> handleMissingAnswer(CallTrace trace, KClass<?> returnType) {
        Answer answer;
        if (this.mockMode == MockMode.autofill) {
            answer = Answer.Autofill.INSTANCE;
        } else if (this.mockMode == MockMode.autoUnit && Intrinsics.areEqual(returnType, (Object)Reflection.getOrCreateKotlinClass(Unit.class))) {
            answer = new Answer.Const<Unit>(Unit.INSTANCE);
        } else {
            throw new CallNotMockedException(trace.toString());
        }
        return answer;
    }
}

