//[mokkery-runtime](../../../index.md)/[dev.mokkery.answering](../index.md)/[FunctionScope](index.md)

# FunctionScope

[common]\
@DelicateMokkeryApi

class [FunctionScope](index.md)

Provides a set of mocked function related operations that might be required for implementing [Answer](../-answer/index.md).

## Properties

| Name | Summary |
|---|---|
| [args](args.md) | [common]<br>val [args](args.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;<br>Args passed to mocked method. If method has extension receiver it is passed at the start of this list. |
| [returnType](return-type.md) | [common]<br>val [returnType](return-type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;<br>Return type of mocked method. |
| [self](self.md) | [common]<br>val [self](self.md): [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?<br>Reference to this mock. |
| [supers](supers.md) | [common]<br>val [supers](supers.md): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, [Function](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-function/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;&gt;<br>This map contains available super calls as lambdas of type `(List<Any?>) -> Any?` or `suspend (List<Any?>) -> Any?` depending on a function type. |

## Functions

| Name | Summary |
|---|---|
| [arg](arg.md) | [common]<br>inline fun &lt;[T](arg.md)&gt; [arg](arg.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [T](arg.md)<br>Returns argument with [index](arg.md) from [args](args.md) and expects that it is an instance of type [T](arg.md). |
| [callOriginal](call-original.md) | [common]<br>fun [callOriginal](call-original.md)(args: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;): [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?<br>Calls original method implementation with given [args](call-original.md). |
| [callSuper](call-super.md) | [common]<br>fun [callSuper](call-super.md)(superType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, args: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;): [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?<br>Calls super method of [superType](call-super.md) with given [args](call-super.md) |
| [callSuspendOriginal](call-suspend-original.md) | [common]<br>suspend fun [callSuspendOriginal](call-suspend-original.md)(args: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;): [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?<br>Just like [callOriginal](call-original.md) but for suspend calls. |
| [callSuspendSuper](call-suspend-super.md) | [common]<br>suspend fun [callSuspendSuper](call-suspend-super.md)(superType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, args: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;): [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?<br>Just like [callSuper](call-super.md) but for suspend calls. |
