//[mokkery-runtime](../../index.md)/[dev.mokkery.matcher.varargs](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [VarArgMatcher](-var-arg-matcher/index.md) | [common]<br>sealed interface [VarArgMatcher](-var-arg-matcher/index.md) : [ArgMatcher](../dev.mokkery.matcher/-arg-matcher/index.md)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; <br>Wildcard vararg matcher that checks a subset of varargs. It can occur only once. To provide your own implementation use [Base](-var-arg-matcher/-base/index.md). |

## Functions

| Name | Summary |
|---|---|
| [anyVarargs](any-varargs.md) | [common]<br>inline fun &lt;[T](any-varargs.md)&gt; [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargs](any-varargs.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](any-varargs.md)&gt;<br>Matches any sequence of varargs. |
| [anyVarargsBoolean](any-varargs-boolean.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsBoolean](any-varargs-boolean.md)(): [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html). |
| [anyVarargsByte](any-varargs-byte.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsByte](any-varargs-byte.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html). |
| [anyVarargsChar](any-varargs-char.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsChar](any-varargs-char.md)(): [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html). |
| [anyVarargsDouble](any-varargs-double.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsDouble](any-varargs-double.md)(): [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html). |
| [anyVarargsFloat](any-varargs-float.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsFloat](any-varargs-float.md)(): [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html). |
| [anyVarargsInt](any-varargs-int.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsInt](any-varargs-int.md)(): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html). |
| [anyVarargsLong](any-varargs-long.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsLong](any-varargs-long.md)(): [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html). |
| [anyVarargsShort](any-varargs-short.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsShort](any-varargs-short.md)(): [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html). |
| [anyVarargsUByte](any-varargs-u-byte.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsUByte](any-varargs-u-byte.md)(): [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html). |
| [anyVarargsUInt](any-varargs-u-int.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsUInt](any-varargs-u-int.md)(): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [UIntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int-array/index.html). |
| [anyVarargsULong](any-varargs-u-long.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsULong](any-varargs-u-long.md)(): [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html). |
| [anyVarargsUShort](any-varargs-u-short.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[anyVarargsUShort](any-varargs-u-short.md)(): [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html)<br>[anyVarargs](any-varargs.md) variant for [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html). |
| [varargsAll](varargs-all.md) | [common]<br>inline fun &lt;[T](varargs-all.md)&gt; [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsAll](varargs-all.md)(noinline predicate: ([T](varargs-all.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](varargs-all.md)&gt;<br>Matches a sequence of varargs with all elements satisfying the given [predicate](varargs-all.md). |
| [varargsAny](varargs-any.md) | [common]<br>inline fun &lt;[T](varargs-any.md)&gt; [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsAny](varargs-any.md)(noinline predicate: ([T](varargs-any.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](varargs-any.md)&gt;<br>Matches a sequence of varargs with any element satisfying the given [predicate](varargs-any.md). |
| [varargsBooleanAll](varargs-boolean-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsBooleanAll](varargs-boolean-all.md)(noinline predicate: ([Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html)<br>[varargsAll](varargs-all.md) variant for [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html). |
| [varargsBooleanAny](varargs-boolean-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsBooleanAny](varargs-boolean-any.md)(noinline predicate: ([Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html)<br>[varargsAny](varargs-any.md) variant for [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html). |
| [varargsByteAll](varargs-byte-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsByteAll](varargs-byte-all.md)(noinline predicate: ([Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[varargsAll](varargs-all.md) variant for [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html). |
| [varargsByteAny](varargs-byte-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsByteAny](varargs-byte-any.md)(noinline predicate: ([Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[varargsAny](varargs-any.md) variant for [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html). |
| [varargsCharAll](varargs-char-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsCharAll](varargs-char-all.md)(noinline predicate: ([Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html)<br>[varargsAll](varargs-all.md) variant for [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html). |
| [varargsCharAny](varargs-char-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsCharAny](varargs-char-any.md)(noinline predicate: ([Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html)<br>[varargsAny](varargs-any.md) variant for [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html). |
| [varargsDoubleAll](varargs-double-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsDoubleAll](varargs-double-all.md)(noinline predicate: ([Double](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html)<br>[varargsAll](varargs-all.md) variant for [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html). |
| [varargsDoubleAny](varargs-double-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsDoubleAny](varargs-double-any.md)(noinline predicate: ([Double](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html)<br>[varargsAny](varargs-any.md) variant for [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html). |
| [varargsFloatAll](varargs-float-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsFloatAll](varargs-float-all.md)(noinline predicate: ([Float](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html)<br>[varargsAll](varargs-all.md) variant for [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html). |
| [varargsFloatAny](varargs-float-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsFloatAny](varargs-float-any.md)(noinline predicate: ([Float](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html)<br>[varargsAny](varargs-any.md) variant for [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html). |
| [varargsIntAll](varargs-int-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsIntAll](varargs-int-all.md)(noinline predicate: ([Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[varargsAll](varargs-all.md) variant for [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html). |
| [varargsIntAny](varargs-int-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsIntAny](varargs-int-any.md)(noinline predicate: ([Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[varargsAny](varargs-any.md) variant for [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html). |
| [varargsLongAll](varargs-long-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsLongAll](varargs-long-all.md)(noinline predicate: ([Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html)<br>[varargsAll](varargs-all.md) variant for [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html). |
| [varargsLongAny](varargs-long-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsLongAny](varargs-long-any.md)(noinline predicate: ([Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html)<br>[varargsAny](varargs-any.md) variant for [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html). |
| [varargsShortAll](varargs-short-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsShortAll](varargs-short-all.md)(noinline predicate: ([Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html)<br>[varargsAll](varargs-all.md) variant for [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html). |
| [varargsShortAny](varargs-short-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsShortAny](varargs-short-any.md)(noinline predicate: ([Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html)<br>[varargsAny](varargs-any.md) variant for [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html). |
| [varargsUByteAll](varargs-u-byte-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsUByteAll](varargs-u-byte-all.md)(noinline predicate: ([UByte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html)<br>[varargsAll](varargs-all.md) variant for [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html). |
| [varargsUByteAny](varargs-u-byte-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsUByteAny](varargs-u-byte-any.md)(noinline predicate: ([UByte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html)<br>[varargsAny](varargs-any.md) variant for [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html). |
| [varargsUIntAll](varargs-u-int-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsUIntAll](varargs-u-int-all.md)(noinline predicate: ([UInt](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[varargsAll](varargs-all.md) variant for [UIntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int-array/index.html). |
| [varargsUIntAny](varargs-u-int-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsUIntAny](varargs-u-int-any.md)(noinline predicate: ([UInt](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[varargsAny](varargs-any.md) variant for [UIntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int-array/index.html). |
| [varargsULongAll](varargs-u-long-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsULongAll](varargs-u-long-all.md)(noinline predicate: ([ULong](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html)<br>[varargsAll](varargs-all.md) variant for [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html). |
| [varargsULongAny](varargs-u-long-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsULongAny](varargs-u-long-any.md)(noinline predicate: ([ULong](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html)<br>[varargsAny](varargs-any.md) variant for [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html). |
| [varargsUShortAll](varargs-u-short-all.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsUShortAll](varargs-u-short-all.md)(noinline predicate: ([UShort](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html)<br>[varargsAll](varargs-all.md) variant for [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html). |
| [varargsUShortAny](varargs-u-short-any.md) | [common]<br>inline fun [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[varargsUShortAny](varargs-u-short-any.md)(noinline predicate: ([UShort](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html)<br>[varargsAny](varargs-any.md) variant for [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html). |
