//[mokkery-runtime](../../index.md)/[dev.mokkery.answering](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [Answer](-answer/index.md) | [common]<br>@DelicateMokkeryApi<br>interface [Answer](-answer/index.md)&lt;out [T](-answer/index.md)&gt;<br>An answer for a function call. For blocking answers only [call](-answer/call.md) implementation is required. For suspending answers [callSuspend](-answer/call-suspend.md) should be implemented and [call](-answer/call.md) implementation should throw an exception. Use [Suspending](-answer/-suspending/index.md) for convenience. |
| [AnsweringScope](-answering-scope/index.md) | [common]<br>interface [AnsweringScope](-answering-scope/index.md)&lt;[T](-answering-scope/index.md)&gt;<br>Scope for defining an answer for a function call. |
| [BlockingAnsweringScope](-blocking-answering-scope/index.md) | [common]<br>interface [BlockingAnsweringScope](-blocking-answering-scope/index.md)&lt;[T](-blocking-answering-scope/index.md)&gt; : [AnsweringScope](-answering-scope/index.md)&lt;[T](-blocking-answering-scope/index.md)&gt; <br>Marker interface for defining an answer for non-suspend function call. |
| [FunctionScope](-function-scope/index.md) | [common]<br>class [FunctionScope](-function-scope/index.md)(val returnType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, val args: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;)<br>Provides function call arguments. If function has any extension receiver, it is provided at the beginning of the [args](-function-scope/args.md) list. |
| [SuspendAnsweringScope](-suspend-answering-scope/index.md) | [common]<br>interface [SuspendAnsweringScope](-suspend-answering-scope/index.md)&lt;[T](-suspend-answering-scope/index.md)&gt; : [AnsweringScope](-answering-scope/index.md)&lt;[T](-suspend-answering-scope/index.md)&gt; <br>Marker interface for defining an answer for suspend function call. |

## Functions

| Name | Summary |
|---|---|
| [calls](calls.md) | [common]<br>infix fun &lt;[T](calls.md)&gt; [BlockingAnsweringScope](-blocking-answering-scope/index.md)&lt;[T](calls.md)&gt;.[calls](calls.md)(block: ([FunctionScope](-function-scope/index.md)) -&gt; [T](calls.md))<br>Function call executes [block](calls.md).<br>[common]<br>infix fun &lt;[T](calls.md)&gt; [SuspendAnsweringScope](-suspend-answering-scope/index.md)&lt;[T](calls.md)&gt;.[calls](calls.md)(block: suspend ([FunctionScope](-function-scope/index.md)) -&gt; [T](calls.md))<br>Suspend function call executes [block](calls.md). |
| [returns](returns.md) | [common]<br>infix fun &lt;[T](returns.md)&gt; [AnsweringScope](-answering-scope/index.md)&lt;[T](returns.md)&gt;.[returns](returns.md)(value: [T](returns.md))<br>Function call always returns [value](returns.md). |
| [throws](throws.md) | [common]<br>infix fun &lt;[T](throws.md)&gt; [AnsweringScope](-answering-scope/index.md)&lt;[T](throws.md)&gt;.[throws](throws.md)(error: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html))<br>Function call always throws [error](throws.md). |
