//[mokkery-runtime](../../../index.md)/[dev.mokkery.matcher.capture](../index.md)/[SlotCapture](index.md)

# SlotCapture

[common]\
interface [SlotCapture](index.md)&lt;[T](index.md)&gt; : [Capture](../-capture/index.md)&lt;[T](index.md)&gt; 

[Capture](../-capture/index.md) that stores only the last value.

## Types

| Name | Summary |
|---|---|
| [Value](-value/index.md) | [common]<br>interface [Value](-value/index.md)&lt;out [T](-value/index.md)&gt; |

## Properties

| Name | Summary |
|---|---|
| [isAbsent](../is-absent.md) | [common]<br>val &lt;[T](../is-absent.md)&gt; [SlotCapture](index.md)&lt;[T](../is-absent.md)&gt;.[isAbsent](../is-absent.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [SlotCapture.value](value.md) is [SlotCapture.Value.Absent](-value/-absent/index.md). |
| [isPresent](../is-present.md) | [common]<br>val &lt;[T](../is-present.md)&gt; [SlotCapture](index.md)&lt;[T](../is-present.md)&gt;.[isPresent](../is-present.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [SlotCapture.value](value.md) is [SlotCapture.Value.Present](-value/-present/index.md). |
| [value](value.md) | [common]<br>abstract val [value](value.md): [SlotCapture.Value](-value/index.md)&lt;[T](index.md)&gt;<br>If no captured values it returns [Value.Absent](-value/-absent/index.md). Otherwise, it returns the last captured value wrapped with [Value.Present](-value/-present/index.md) |
| [values](values.md) | [common]<br>abstract override val [values](values.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[T](index.md)&gt;<br>Contains only latest value. |

## Functions

| Name | Summary |
|---|---|
| [capture](../-capture/capture.md) | [common]<br>abstract fun [capture](../-capture/capture.md)(value: [T](index.md)) |
| [get](../get.md) | [common]<br>fun &lt;[T](../get.md)&gt; [SlotCapture](index.md)&lt;[T](../get.md)&gt;.[get](../get.md)(): [T](../get.md)<br>Returns unwrapped [SlotCapture.value](value.md) if it is [SlotCapture.Value.Present](-value/-present/index.md). Otherwise, it fails. |
| [getIfPresent](../get-if-present.md) | [common]<br>fun &lt;[T](../get-if-present.md)&gt; [SlotCapture](index.md)&lt;[T](../get-if-present.md)&gt;.[getIfPresent](../get-if-present.md)(): [T](../get-if-present.md)?<br>Returns unwrapped [SlotCapture.value](value.md) if it is [SlotCapture.Value.Present](-value/-present/index.md). Otherwise, it returns null. |
| [getValue](../get-value.md) | [common]<br>operator fun &lt;[T](../get-value.md)&gt; [SlotCapture](index.md)&lt;[T](../get-value.md)&gt;.[getValue](../get-value.md)(thisRef: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, property: [KProperty](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-property/index.html)&lt;*&gt;): [T](../get-value.md)?<br>Just like [getIfPresent](../get-if-present.md), but as a [getValue](../get-value.md) operator. |
