//[mokkery-core](../../../../index.md)/[dev.mokkery.verify](../../index.md)/[VerifyMode](../index.md)/[Companion](index.md)

# Companion

[common]\
object [Companion](index.md)

## Properties

| Name | Summary |
|---|---|
| [exhaustive](exhaustive.md) | [common]<br>val [exhaustive](exhaustive.md): [VerifyMode](../index.md)<br>Verifies that each function call occurred at least once in any order and there is no more calls. |
| [exhaustiveOrder](exhaustive-order.md) | [common]<br>val [exhaustiveOrder](exhaustive-order.md): [VerifyMode](../index.md)<br>Verifies that given calls occurred in exact same order and there is no more calls. |
| [not](not.md) | [common]<br>val [not](not.md): [VerifyMode](../index.md)<br>Verifies that none of the specified calls occurred. |
| [order](order.md) | [common]<br>val [order](order.md): [VerifyMode](../index.md)<br>Verifies that given calls occurred in specified order. It allows other calls in between. |
| [soft](soft.md) | [common]<br>val [soft](soft.md): [VerifyMode](../index.md)<br>Verifies that each function call occurred at least once in any order. It allows unverified calls. |

## Functions

| Name | Summary |
|---|---|
| [atLeast](at-least.md) | [common]<br>fun [atLeast](at-least.md)(n: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [VerifyMode](../index.md)<br>Verifies that each function call occurred at least [n](at-least.md) times. It allows unverified calls. |
| [atMost](at-most.md) | [common]<br>fun [atMost](at-most.md)(n: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [VerifyMode](../index.md)<br>Verifies that each function call occurred at least once and at most [n](at-most.md) times. It allows unverified calls. |
| [exactly](exactly.md) | [common]<br>fun [exactly](exactly.md)(n: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [VerifyMode](../index.md)<br>Verifies that each function call occurred exactly [n](exactly.md) times. It allows unverified calls. |
| [inRange](in-range.md) | [common]<br>fun [inRange](in-range.md)(range: [IntRange](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.ranges/-int-range/index.html)): [VerifyMode](../index.md)<br>Verifies that number of calls for each function is within the given [range](in-range.md). It allows unverified calls. |
