//[mokkery-core](../../../index.md)/[dev.mokkery](../index.md)/[MockMode](index.md)

# MockMode

[common]\
enum [MockMode](index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[MockMode](index.md)&gt; 

Determines behaviour for a mock when user-configured answer is missing.

## Entries

| | |
|---|---|
| [strict](strict/index.md) | [common]<br>[strict](strict/index.md)<br>Fails on missing answer. |
| [autofill](autofill/index.md) | [common]<br>[autofill](autofill/index.md)<br>Provides default *empty* value (e.g. 0 for numbers, &quot;&quot; for string, null for complex types) |
| [autoUnit](auto-unit/index.md) | [common]<br>[autoUnit](auto-unit/index.md)<br>Returns [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) for functions that return [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html), otherwise fails. |

## Properties

| Name | Summary |
|---|---|
| [name](auto-unit/index.md#-372974862%2FProperties%2F407253833) | [common]<br>val [name](auto-unit/index.md#-372974862%2FProperties%2F407253833): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [ordinal](auto-unit/index.md#-739389684%2FProperties%2F407253833) | [common]<br>val [ordinal](auto-unit/index.md#-739389684%2FProperties%2F407253833): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

## Functions

| Name | Summary |
|---|---|
| [valueOf](value-of.md) | [common]<br>fun [valueOf](value-of.md)(value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [MockMode](index.md)<br>Returns the enum constant of this type with the specified name. The string must match exactly an identifier used to declare an enum constant in this type. (Extraneous whitespace characters are not permitted.) |
| [values](values.md) | [common]<br>fun [values](values.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[MockMode](index.md)&gt;<br>Returns an array containing the constants of this enum type, in the order they're declared. |
