/*
 * Decompiled with CFR 0.152.
 */
package dev.mlnr.blh.core.api;

import dev.mlnr.blh.core.api.BotList;
import dev.mlnr.blh.core.api.IBLHUpdater;
import dev.mlnr.blh.core.internal.config.AutoPostingConfig;
import dev.mlnr.blh.core.internal.config.LoggingConfig;
import dev.mlnr.blh.core.internal.utils.Checks;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotListHandler {
    private final Map<BotList, String> botLists;
    private final Predicate<Long> devModePredicate;
    private final boolean unavailableEventsEnabled;
    private final AutoPostingConfig autoPostingConfig;
    private final LoggingConfig loggingConfig;
    private static final Logger logger = LoggerFactory.getLogger(BotListHandler.class);
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor();
    private final OkHttpClient httpClient = new OkHttpClient();
    private final Set<BotList> ratelimitedBotLists;
    private final Set<BotList> unauthorizedBotLists;
    private long previousGuildCount = -1L;

    BotListHandler(Map<BotList, String> botListMap, Predicate<Long> devModePredicate, boolean unavailableEventsEnabled, AutoPostingConfig autoPostingConfig, LoggingConfig loggingConfig) {
        this.botLists = botListMap;
        this.devModePredicate = devModePredicate;
        this.unavailableEventsEnabled = unavailableEventsEnabled;
        this.autoPostingConfig = autoPostingConfig;
        this.loggingConfig = loggingConfig;
        this.ratelimitedBotLists = EnumSet.noneOf(BotList.class);
        this.unauthorizedBotLists = EnumSet.noneOf(BotList.class);
        if (autoPostingConfig.isAutoPostingEnabled()) {
            SCHEDULER.scheduleAtFixedRate(() -> this.updateAllStats(autoPostingConfig.getUpdater()), 0L, autoPostingConfig.getDelay(), autoPostingConfig.getUnit());
        }
    }

    public void addBotList(@Nonnull BotList botList, @Nonnull String token) {
        Checks.checkListAndToken(botList, token);
        this.botLists.put(botList, token);
    }

    public void swapToken(@Nonnull BotList botList, @Nonnull String newToken) {
        String previousToken = this.botLists.get((Object)botList);
        Checks.check(previousToken == null, "The bot list hasn't been added");
        Checks.check(previousToken.equals(newToken), "The new token may not be the same as the previous one");
        this.addBotList(botList, newToken);
        this.unauthorizedBotLists.remove((Object)botList);
    }

    public boolean isAutoPostingEnabled() {
        return this.autoPostingConfig.isAutoPostingEnabled();
    }

    public boolean isUnavailableEventsHandlingEnabled() {
        return this.unavailableEventsEnabled;
    }

    void updateAllStats(IBLHUpdater updater) {
        this.updateAllStats(updater.getBotId(), updater.getServerCount());
    }

    public void updateAllStats(long botId, long serverCount) {
        if (this.devModePredicate.test(botId)) {
            return;
        }
        Checks.notNegative(botId, "The bot id");
        Checks.notNegative(serverCount, "The server amount");
        if (serverCount == this.previousGuildCount) {
            if (this.loggingConfig.isNoUpdateNecessaryLoggingEnabled()) {
                logger.info("No stats updating was necessary.");
            }
            return;
        }
        this.previousGuildCount = serverCount;
        this.botLists.forEach((botList, token) -> this.updateStats((BotList)((Object)botList), (String)token, botId, serverCount, false));
    }

    void updateStats(final BotList botList, final String token, final long botId, final long serverCount, boolean retriedRequest) {
        if (this.ratelimitedBotLists.contains((Object)botList) && !retriedRequest) {
            return;
        }
        final String botListName = botList.name();
        if (this.unauthorizedBotLists.contains((Object)botList)) {
            logger.warn("Dropping stats update for bot list {} as the provided token is invalid. You can hotswap the token by calling swapToken on the BotListHandler instance.", (Object)botListName);
            return;
        }
        String payload = "{\"" + botList.getServersParam() + "\":" + serverCount + "}";
        String url = String.format(botList.getUrl(), botId);
        Request.Builder requestBuilder = new Request.Builder().url(url).header("Authorization", token).post(RequestBody.create(payload, MediaType.parse("application/json")));
        this.httpClient.newCall(requestBuilder.build()).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                logger.error("There was an error while updating the stats for bot list {}", (Object)botListName, (Object)e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                response.close();
                if (response.isSuccessful()) {
                    if (BotListHandler.this.loggingConfig.isSuccessLoggingEnabled()) {
                        logger.info("Successfully updated stats for bot list {}", (Object)botListName);
                    }
                    BotListHandler.this.ratelimitedBotLists.remove((Object)botList);
                } else {
                    int code = response.code();
                    if (code == 401) {
                        logger.error("Failed to update the stats for bot list {} as the provided token is invalid. You can hotswap the token by calling swapToken on the BotListHandler instance.", (Object)botListName);
                        BotListHandler.this.unauthorizedBotLists.add(botList);
                        return;
                    }
                    if (code == 429) {
                        if (BotListHandler.this.loggingConfig.isRatelimitedLoggingEnabled()) {
                            logger.warn("Failed to update the stats for bot list {} as we got ratelimited. Retrying in 15 seconds", (Object)botListName);
                        }
                        BotListHandler.this.ratelimitedBotLists.add(botList);
                        SCHEDULER.schedule(() -> BotListHandler.this.updateStats(botList, token, botId, serverCount, true), 15L, TimeUnit.SECONDS);
                        return;
                    }
                    logger.error("Failed to update the stats for bot list {} with code {}", (Object)botListName, (Object)code);
                }
            }
        });
    }
}

