/*
 * Decompiled with CFR 0.152.
 */
package dev.mlnr.blh.core.api;

import dev.mlnr.blh.core.api.BotList;
import dev.mlnr.blh.core.api.BotListHandler;
import dev.mlnr.blh.core.api.IBLHUpdater;
import dev.mlnr.blh.core.internal.config.AutoPostingConfig;
import dev.mlnr.blh.core.internal.config.LoggingConfig;
import dev.mlnr.blh.core.internal.utils.Checks;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class BLHBuilder {
    private Map<BotList, String> botLists = new EnumMap<BotList, String>(BotList.class);
    private IBLHUpdater updater;
    private long autoPostDelay;
    private TimeUnit autoPostUnit;
    private boolean successLoggingEnabled = true;
    private boolean noUpdateNecessaryLoggingEnabled = true;
    private boolean ratelimitedLoggingEnabled = true;
    private Predicate<Long> devModePredicate = o -> false;
    private boolean unavailableEventsEnabled = true;

    public BLHBuilder() {
    }

    public BLHBuilder(@Nonnull IBLHUpdater updater) {
        Checks.notNull(updater, "The updater instance");
        this.updater = updater;
    }

    public BLHBuilder(@Nonnull IBLHUpdater updater, @Nonnull Map<BotList, String> botLists) {
        Checks.notNull(updater, "The updater instance");
        this.setBotLists(botLists);
        this.updater = updater;
    }

    public BLHBuilder(@Nonnull Map<BotList, String> botLists) {
        this.setBotLists(botLists);
    }

    public BLHBuilder addBotList(@Nonnull BotList botList, @Nonnull String token) {
        Checks.checkListAndToken(botList, token);
        this.botLists.put(botList, token);
        return this;
    }

    public BLHBuilder setBotLists(@Nonnull Map<BotList, String> botLists) {
        this.checkBotListsMap(botLists);
        botLists.forEach((botList, token) -> Checks.checkToken(token));
        this.botLists = botLists;
        return this;
    }

    public BLHBuilder setAutoPostDelay(long delay, @Nonnull TimeUnit unit) {
        Checks.check(this.updater == null, "The updater instance has to be set to use autoposting");
        Checks.check(delay < 1L, "The delay cannot be less than 1");
        Checks.notNull((Object)unit, "The time unit");
        Checks.check(unit.ordinal() < TimeUnit.MINUTES.ordinal(), "The time unit cannot be smaller than minutes");
        this.autoPostDelay = delay;
        this.autoPostUnit = unit;
        return this;
    }

    public BLHBuilder setSuccessLoggingEnabled(boolean enabled) {
        this.successLoggingEnabled = enabled;
        return this;
    }

    public BLHBuilder setNoUpdateNecessaryLoggingEnabled(boolean enabled) {
        this.noUpdateNecessaryLoggingEnabled = enabled;
        return this;
    }

    public BLHBuilder setRatelimitedLoggingEnabled(boolean enabled) {
        this.ratelimitedLoggingEnabled = enabled;
        return this;
    }

    public BLHBuilder setDevModePredicate(@Nonnull Predicate<Long> predicate) {
        Checks.notNull(predicate, "The dev mode predicate");
        this.devModePredicate = predicate;
        return this;
    }

    public BLHBuilder setUnavailableEventsEnabled(boolean enabled) {
        this.unavailableEventsEnabled = enabled;
        return this;
    }

    public BotListHandler build() {
        this.checkBotListsMap(this.botLists);
        Checks.check(this.updater != null && this.autoPostDelay == 0L, "The autoposting delay has to be set");
        return new BotListHandler(this.botLists, this.devModePredicate, this.unavailableEventsEnabled, new AutoPostingConfig(this.updater, this.autoPostDelay, this.autoPostUnit), new LoggingConfig(this.successLoggingEnabled, this.noUpdateNecessaryLoggingEnabled, this.ratelimitedLoggingEnabled));
    }

    private void checkBotListsMap(Map<BotList, String> map) {
        Checks.notEmpty(map, "The bot lists map");
    }
}

