/*
 * Decompiled with CFR 0.152.
 */
package dev.mlnr.blh.core.internal.utils;

import dev.mlnr.blh.core.api.BotList;
import java.util.Collection;
import java.util.Map;

public class Checks {
    private Checks() {
    }

    public static void check(boolean condition, String message) {
        if (condition) {
            throw new IllegalStateException(message);
        }
    }

    public static void notNull(Object o, String name) {
        if (o == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
    }

    public static void notEmpty(Map<?, ?> map, String name) {
        Checks.notNull(map, name);
        if (map.isEmpty()) {
            throw new IllegalArgumentException(name + " may not be empty");
        }
    }

    public static void notEmpty(String string, String name) {
        Checks.notNull(string, name);
        if (string.isEmpty()) {
            throw new IllegalStateException(name + " may not be empty");
        }
    }

    public static void notNegative(long l, String name) {
        if (l < 0L) {
            throw new IllegalArgumentException(name + " may not be negative");
        }
    }

    public static void noneNull(Object[] objects, String name) {
        for (Object o : objects) {
            Checks.notNull(o, name);
        }
    }

    public static void noneNull(Collection<?> collection, String name) {
        for (Object o : collection) {
            Checks.notNull(o, name);
        }
    }

    public static void checkListAndToken(BotList botList, String token) {
        Checks.notNull((Object)botList, "The bot list");
        Checks.checkToken(token);
    }

    public static void checkToken(String token) {
        Checks.notEmpty(token, "The bot list token");
    }
}

