/*
 * Decompiled with CFR 0.152.
 */
package dev.mlnr.blh.jda;

import dev.mlnr.blh.core.api.BotListHandler;
import dev.mlnr.blh.core.internal.utils.Checks;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.events.ReadyEvent;
import net.dv8tion.jda.api.events.guild.GuildJoinEvent;
import net.dv8tion.jda.api.events.guild.GuildLeaveEvent;
import net.dv8tion.jda.api.events.guild.UnavailableGuildJoinedEvent;
import net.dv8tion.jda.api.events.guild.UnavailableGuildLeaveEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;

public class BLHJDAListener
extends ListenerAdapter {
    private final BotListHandler botListHandler;

    public BLHJDAListener(@Nonnull BotListHandler botListHandler) {
        Checks.notNull(botListHandler, "The BotListHandler instance");
        Checks.check(botListHandler.isAutoPostingEnabled(), "Can only use event based updating if autoposting is disabled");
        this.botListHandler = botListHandler;
    }

    public void onReady(ReadyEvent event) {
        JDA jda = event.getJDA();
        this.botListHandler.updateAllStats(jda.getSelfUser().getIdLong(), jda.getGuildCache().size());
    }

    public void onGuildJoin(GuildJoinEvent event) {
        JDA jda = event.getJDA();
        this.botListHandler.updateAllStats(jda.getSelfUser().getIdLong(), jda.getGuildCache().size());
    }

    public void onGuildLeave(GuildLeaveEvent event) {
        JDA jda = event.getJDA();
        this.botListHandler.updateAllStats(jda.getSelfUser().getIdLong(), jda.getGuildCache().size());
    }

    public void onUnavailableGuildJoined(UnavailableGuildJoinedEvent event) {
        if (this.botListHandler.isUnavailableEventsHandlingEnabled()) {
            JDA jda = event.getJDA();
            this.botListHandler.updateAllStats(jda.getSelfUser().getIdLong(), jda.getGuildCache().size());
        }
    }

    public void onUnavailableGuildLeave(UnavailableGuildLeaveEvent event) {
        if (this.botListHandler.isUnavailableEventsHandlingEnabled()) {
            JDA jda = event.getJDA();
            this.botListHandler.updateAllStats(jda.getSelfUser().getIdLong(), jda.getGuildCache().size());
        }
    }
}

