/*
 * Decompiled with CFR 0.152.
 */
package dev.misir.rapiddbtest.core.postgres;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresDatabaseManager {
    private final Logger log = LoggerFactory.getLogger(PostgresDatabaseManager.class);
    private final Config config;

    public PostgresDatabaseManager(String host, int port, String adminDatabaseName, String adminDatabaseUser, String adminDatabasePassword, String originalDatabaseName) {
        this(String.format("jdbc:postgresql://%s:%d/%s", host, port, adminDatabaseName), adminDatabaseUser, adminDatabasePassword, originalDatabaseName);
    }

    public PostgresDatabaseManager(String jdbcUrl, String adminDatabaseUser, String adminDatabasePassword, String originalDatabaseName) {
        this.validateDatabaseName(originalDatabaseName);
        this.config = new Config(jdbcUrl, adminDatabaseUser, adminDatabasePassword, originalDatabaseName);
    }

    private void validateDatabaseName(String databaseName) {
        if (databaseName == null || databaseName.isEmpty() || !databaseName.matches("^[a-zA-Z_][a-zA-Z0-9_]*$")) {
            throw new IllegalArgumentException("Invalid database name: " + databaseName);
        }
    }

    public void initialize() {
        this.ensureOriginalDatabaseExists();
        if (!this.doesTemplateDbExists()) {
            this.createTemplateDatabase();
        }
        this.recreateTestDatabaseFromTemplate();
    }

    public void reset() {
        try (Connection connection = this.getAdminDatabaseConnection();
             Statement stmt = connection.createStatement();){
            this.terminateAllDatabaseConnections(connection);
            connection.setAutoCommit(true);
            this.dropTemplateAndOriginalDatabases(stmt);
            this.recreateOriginalDatabase(stmt);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to reset test environment", e);
        }
    }

    public void createTemplateDatabase() {
        this.log.info("Creating template database...");
        try (Connection connection = this.getAdminDatabaseConnection();
             Statement stmt = connection.createStatement();){
            this.terminateAllDatabaseConnections(connection);
            connection.setAutoCommit(true);
            this.createTemplateFromOriginal(stmt);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create template database", e);
        }
        this.log.info("Template database created.");
    }

    private void dropTemplateAndOriginalDatabases(Statement stmt) throws SQLException {
        stmt.execute(String.format("DO $$ BEGIN IF EXISTS (SELECT 1 FROM pg_database WHERE datname = '%s') THEN EXECUTE 'ALTER DATABASE %s IS_TEMPLATE false'; END IF; END $$;", this.config.getTemplateDatabaseName(), this.config.getTemplateDatabaseName()));
        stmt.execute(String.format("DROP DATABASE IF EXISTS %s;", this.config.getTemplateDatabaseName()));
        stmt.execute(String.format("DROP DATABASE IF EXISTS %s;", this.config.getOriginalDatabaseName()));
    }

    private void recreateOriginalDatabase(Statement stmt) throws SQLException {
        stmt.execute(String.format("CREATE DATABASE %s;", this.config.getOriginalDatabaseName()));
    }

    private void createTemplateFromOriginal(Statement stmt) throws SQLException {
        stmt.execute(String.format("ALTER DATABASE %s IS_TEMPLATE true;", this.config.getOriginalDatabaseName()));
        stmt.execute(String.format("CREATE DATABASE %s TEMPLATE %s;", this.config.getTemplateDatabaseName(), this.config.getOriginalDatabaseName()));
        stmt.execute(String.format("ALTER DATABASE %s IS_TEMPLATE false;", this.config.getOriginalDatabaseName()));
        stmt.execute(String.format("ALTER DATABASE %s IS_TEMPLATE true;", this.config.getTemplateDatabaseName()));
    }

    private void ensureOriginalDatabaseExists() {
        String query = String.format("SELECT 1 FROM pg_database WHERE datname = '%s'", this.config.getOriginalDatabaseName());
        try (PreparedStatement statement = this.getAdminDatabaseConnection().prepareStatement(query);
             ResultSet rs = statement.executeQuery();){
            if (!rs.next()) {
                this.createDatabase(this.config.getOriginalDatabaseName());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void recreateTestDatabaseFromTemplate() {
        this.log.info("Creating new database from template database.");
        try (Connection con = this.getAdminDatabaseConnection();
             Statement stmt = con.createStatement();){
            this.terminateAllDatabaseConnections(con);
            stmt.execute(String.format("DROP DATABASE %s;", this.config.getOriginalDatabaseName()));
            stmt.execute(String.format("CREATE DATABASE %s TEMPLATE %s;", this.config.getOriginalDatabaseName(), this.config.getTemplateDatabaseName()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.log.info("Database from template created.");
    }

    private void terminateAllDatabaseConnections(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            stmt.execute(String.format("SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE datname = '%s'", this.config.getTemplateDatabaseName()));
            stmt.execute(String.format("SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE datname = '%s'", this.config.getOriginalDatabaseName()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Connection getAdminDatabaseConnection() throws SQLException {
        return DriverManager.getConnection(this.config.getConnectionString(), this.config.getAdminDatabaseUser(), this.config.getAdminDatabasePassword());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean doesTemplateDbExists() {
        String query = String.format("SELECT datistemplate FROM pg_database WHERE datname = '%s'", this.config.getTemplateDatabaseName());
        try (PreparedStatement statement = this.getAdminDatabaseConnection().prepareStatement(query);){
            boolean bl;
            block18: {
                ResultSet rs;
                block16: {
                    boolean bl2;
                    block17: {
                        rs = statement.executeQuery();
                        try {
                            if (!rs.next()) break block16;
                            bl2 = rs.getBoolean("datistemplate");
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl2;
                }
                bl = false;
                if (rs == null) break block18;
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void createDatabase(String dbName) {
        String createQuery = String.format("CREATE DATABASE %s", dbName);
        try (PreparedStatement createStatement = this.getAdminDatabaseConnection().prepareStatement(createQuery);){
            createStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create database " + dbName, e);
        }
    }

    private static class Config {
        private final String connectionString;
        private final String adminDatabaseUser;
        private final String adminDatabasePassword;
        private final String originalDatabaseName;

        public Config(String connectionString, String adminDatabaseUser, String adminDatabasePassword, String originalDatabaseName) {
            this.connectionString = connectionString;
            this.adminDatabaseUser = adminDatabaseUser;
            this.adminDatabasePassword = adminDatabasePassword;
            this.originalDatabaseName = originalDatabaseName;
        }

        public String getAdminDatabaseUser() {
            return this.adminDatabaseUser;
        }

        public String getAdminDatabasePassword() {
            return this.adminDatabasePassword;
        }

        public String getOriginalDatabaseName() {
            return this.originalDatabaseName;
        }

        public String getConnectionString() {
            return this.connectionString;
        }

        public String getTemplateDatabaseName() {
            return this.originalDatabaseName + "_template_db";
        }
    }
}

