package dev.minimul.toolkit.arch.lifecycle

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.SupervisorJob
import kotlinx.coroutines.cancelChildren
import org.koin.core.component.KoinComponent
import org.koin.core.component.inject

expect open class PlatformViewModel constructor() : KoinComponent {
    open fun cleanup()
}

abstract class CommonViewModel : PlatformViewModel() {
    @Suppress("MemberVisibilityCanBePrivate")
    internal val dispatcher: PlatformDispatcher by inject()

    internal val scope = CoroutineScope(SupervisorJob() + dispatcher.main)

    override fun cleanup() {
        super.cleanup()
        scope.coroutineContext.cancelChildren()
    }
}