/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.microhttp.systemlogger;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.microhttp.LogEntry;
import org.microhttp.Logger;

public final class SystemLogger
implements Logger {
    private final System.Logger logger;
    private final System.Logger.Level level;

    public SystemLogger() {
        this(System.Logger.Level.TRACE);
    }

    public SystemLogger(System.Logger logger) {
        this(logger, System.Logger.Level.TRACE);
    }

    public SystemLogger(System.Logger.Level level) {
        this(System.getLogger(SystemLogger.class.toString()), level);
    }

    public SystemLogger(System.Logger logger, System.Logger.Level level) {
        this.logger = Objects.requireNonNull(logger);
        this.level = Objects.requireNonNull(level);
    }

    public boolean enabled() {
        return true;
    }

    public void log(LogEntry ... entries) {
        this.logger.log(this.level, () -> Arrays.stream(entries).map(entry -> entry.key() + "=" + entry.value()).collect(Collectors.joining(", ")));
    }

    public void log(Exception e, LogEntry ... entries) {
        this.logger.log(this.level, () -> Arrays.stream(entries).map(entry -> entry.key() + "=" + entry.value()).collect(Collectors.joining(", ")), (Throwable)e);
    }
}

