/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.microhttp.redirect;

import dev.mccue.microhttp.handler.IntoResponse;
import dev.mccue.reasonphrase.ReasonPhrase;
import java.util.List;
import java.util.Objects;
import org.microhttp.Header;
import org.microhttp.Response;

public final class RedirectResponse
implements IntoResponse {
    private final Status status;
    private final String location;

    private RedirectResponse(Status status, String location) {
        this.status = status;
        this.location = Objects.requireNonNull(location);
    }

    public static RedirectResponse movedPermanently(String location) {
        return new RedirectResponse(Status.MOVED_PERMANENTLY, location);
    }

    public static RedirectResponse found(String location) {
        return new RedirectResponse(Status.FOUND, location);
    }

    public static RedirectResponse seeOther(String location) {
        return new RedirectResponse(Status.SEE_OTHER, location);
    }

    public static RedirectResponse temporary(String location) {
        return new RedirectResponse(Status.TEMPORARY_REDIRECT, location);
    }

    public static RedirectResponse permanent(String location) {
        return new RedirectResponse(Status.PERMANENT_REDIRECT, location);
    }

    public Response intoResponse() {
        return new Response(this.status.code, ReasonPhrase.forStatus((int)this.status.code), List.of(new Header("Location", this.location)), new byte[0]);
    }

    public String toString() {
        return "RedirectResponse[status=" + String.valueOf((Object)this.status) + ", location='" + this.location + "']";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof RedirectResponse)) return false;
        RedirectResponse response = (RedirectResponse)obj;
        if (this.status != response.status) return false;
        if (!this.location.equals(response.location)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.location});
    }

    static enum Status {
        MOVED_PERMANENTLY(301),
        FOUND(302),
        SEE_OTHER(303),
        TEMPORARY_REDIRECT(307),
        PERMANENT_REDIRECT(308);

        final int code;

        private Status(int code) {
            this.code = code;
        }
    }
}

