/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.microhttp.handler;

import dev.mccue.microhttp.handler.Handler;
import dev.mccue.microhttp.handler.IntoResponse;
import java.util.List;
import java.util.Objects;
import org.microhttp.Request;

public class DelegatingHandler
implements Handler {
    private final List<Handler> handlers;
    private final IntoResponse notHandled;

    public DelegatingHandler(List<? extends Handler> handlers, IntoResponse notHandled) {
        this.handlers = List.copyOf(handlers);
        this.notHandled = Objects.requireNonNull(notHandled);
    }

    @Override
    public IntoResponse handle(Request request) throws Exception {
        try {
            for (Handler handler : this.handlers) {
                IntoResponse intoResponse = handler.handle(request);
                if (intoResponse == null) continue;
                return intoResponse;
            }
        }
        catch (Exception e) {
            if (e instanceof IntoResponse) {
                IntoResponse intoResponse = (IntoResponse)((Object)e);
                return intoResponse;
            }
            throw e;
        }
        return this.notHandled;
    }
}

