/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.decode.alpha;

import dev.mccue.json.Json;
import dev.mccue.json.decode.alpha.JsonDecodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public interface Decoder<T> {
    public T decode(Json var1) throws JsonDecodingException;

    default public <R> Decoder<R> map(Function<? super T, ? extends R> f) {
        return value -> f.apply((T)this.decode(value));
    }

    public static <T> Decoder<T> of(Decoder<? extends T> decoder) {
        return decoder::decode;
    }

    public static String string(Json json) throws JsonDecodingException {
        if (!(json instanceof Json.String)) {
            throw JsonDecodingException.of("expected a string", json);
        }
        Json.String jsonString = (Json.String)json;
        return jsonString.value();
    }

    public static boolean boolean_(Json json) throws JsonDecodingException {
        if (!(json instanceof Json.Boolean)) {
            throw JsonDecodingException.of("expected a boolean", json);
        }
        Json.Boolean jsonBoolean = (Json.Boolean)json;
        return jsonBoolean.value();
    }

    public static int int_(Json json) throws JsonDecodingException {
        if (!(json instanceof Json.Number)) {
            throw JsonDecodingException.of("expected a number", json);
        }
        Json.Number jsonNumber = (Json.Number)json;
        if (!jsonNumber.isIntegral()) {
            throw JsonDecodingException.of("expected a number with no decimal part", json);
        }
        try {
            return jsonNumber.intValueExact();
        }
        catch (ArithmeticException e) {
            throw JsonDecodingException.of("expected a number which could be converted to an int", json);
        }
    }

    public static long long_(Json json) throws JsonDecodingException {
        if (!(json instanceof Json.Number)) {
            throw JsonDecodingException.of("expected a number", json);
        }
        Json.Number jsonNumber = (Json.Number)json;
        if (!jsonNumber.isIntegral()) {
            throw JsonDecodingException.of("expected a number with no decimal part", json);
        }
        try {
            return jsonNumber.longValueExact();
        }
        catch (ArithmeticException e) {
            throw JsonDecodingException.of("expected a number which could be converted to a long", json);
        }
    }

    public static float float_(Json json) throws JsonDecodingException {
        if (!(json instanceof Json.Number)) {
            throw JsonDecodingException.of("expected a number", json);
        }
        Json.Number jsonNumber = (Json.Number)json;
        return jsonNumber.floatValue();
    }

    public static double double_(Json json) throws JsonDecodingException {
        if (!(json instanceof Json.Number)) {
            throw JsonDecodingException.of("expected a number", json);
        }
        Json.Number jsonNumber = (Json.Number)json;
        return jsonNumber.doubleValue();
    }

    public static <T> T null_(Json json) throws JsonDecodingException {
        if (!(json instanceof Json.Null)) {
            throw JsonDecodingException.of("expected null", json);
        }
        return null;
    }

    public static Json.Array array(Json json) throws JsonDecodingException {
        if (!(json instanceof Json.Array)) {
            throw JsonDecodingException.of("expected an array", json);
        }
        Json.Array jsonArray = (Json.Array)json;
        return jsonArray;
    }

    public static <T> List<T> array(Json json, Decoder<? extends T> itemDecoder) throws JsonDecodingException {
        if (!(json instanceof Json.Array)) {
            throw JsonDecodingException.of("expected an array", json);
        }
        Json.Array jsonArray = (Json.Array)json;
        ArrayList<T> items = new ArrayList<T>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            Json jsonItem = (Json)jsonArray.get(i);
            try {
                items.add(itemDecoder.decode(jsonItem));
                continue;
            }
            catch (JsonDecodingException e) {
                throw JsonDecodingException.atIndex(i, e);
            }
            catch (Exception e) {
                throw JsonDecodingException.atIndex(i, JsonDecodingException.of(e, jsonItem));
            }
        }
        return List.copyOf(items);
    }

    public static Json.Object object(Json json) throws JsonDecodingException {
        if (!(json instanceof Json.Object)) {
            throw JsonDecodingException.of("expected an object", json);
        }
        Json.Object jsonObject = (Json.Object)json;
        return jsonObject;
    }

    public static <T> Map<String, T> object(Json json, Decoder<? extends T> valueDecoder) throws JsonDecodingException {
        Json.Object jsonObject = Decoder.object(json);
        HashMap m = new HashMap(jsonObject.size());
        jsonObject.forEach((key, value) -> {
            try {
                m.put(key, valueDecoder.decode((Json)value));
            }
            catch (JsonDecodingException e) {
                throw JsonDecodingException.atField(key, e);
            }
            catch (Exception e) {
                throw JsonDecodingException.atField(key, JsonDecodingException.of(e, value));
            }
        });
        return Collections.unmodifiableMap(m);
    }

    public static <T> Decoder<T> field(String fieldName, Decoder<? extends T> valueDecoder) throws JsonDecodingException {
        return json -> Decoder.field(json, fieldName, valueDecoder);
    }

    public static <T> T field(Json json, String fieldName, Decoder<? extends T> valueDecoder) throws JsonDecodingException {
        Json.Object jsonObject = Decoder.object(json);
        Json value = (Json)jsonObject.get((Object)fieldName);
        if (value == null) {
            throw JsonDecodingException.atField(fieldName, JsonDecodingException.of("no value for field", json));
        }
        try {
            return valueDecoder.decode(value);
        }
        catch (JsonDecodingException e) {
            throw JsonDecodingException.atField(fieldName, e);
        }
        catch (Exception e) {
            throw JsonDecodingException.atField(fieldName, JsonDecodingException.of(e, value));
        }
    }

    public static <T> Decoder<T> optionalField(String fieldName, Decoder<? extends T> valueDecoder, T defaultValue) throws JsonDecodingException {
        return json -> Decoder.optionalField(json, fieldName, valueDecoder, defaultValue);
    }

    public static <T> T optionalField(Json json, String fieldName, Decoder<? extends T> valueDecoder, T defaultValue) throws JsonDecodingException {
        Json.Object jsonObject = Decoder.object(json);
        Json value = (Json)jsonObject.get((Object)fieldName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return valueDecoder.decode(value);
        }
        catch (JsonDecodingException e) {
            throw JsonDecodingException.atField(fieldName, e);
        }
        catch (Exception e) {
            throw JsonDecodingException.atField(fieldName, JsonDecodingException.of(e, value));
        }
    }

    public static <T> Decoder<Optional<T>> optionalField(String fieldName, Decoder<? extends T> valueDecoder) throws JsonDecodingException {
        return json -> Decoder.optionalField(json, fieldName, valueDecoder);
    }

    public static <T> Optional<T> optionalField(Json json, String fieldName, Decoder<? extends T> valueDecoder) throws JsonDecodingException {
        return Decoder.optionalField(json, fieldName, valueDecoder.map(Optional::of), Optional.empty());
    }

    public static <T> Decoder<Optional<T>> optionalNullableField(String fieldName, Decoder<? extends T> valueDecoder) throws JsonDecodingException {
        return json -> Decoder.optionalNullableField(json, fieldName, valueDecoder);
    }

    public static <T> Optional<T> optionalNullableField(Json json, String fieldName, Decoder<? extends T> valueDecoder) throws JsonDecodingException {
        return Decoder.optionalField(json, fieldName, Decoder.nullable(valueDecoder), Optional.empty());
    }

    public static <T> Decoder<T> optionalNullableField(String fieldName, Decoder<? extends T> valueDecoder, T defaultValue) throws JsonDecodingException {
        return json -> Decoder.optionalNullableField(json, fieldName, valueDecoder, defaultValue);
    }

    public static <T> T optionalNullableField(Json json, String fieldName, Decoder<? extends T> valueDecoder, T defaultValue) throws JsonDecodingException {
        Decoder<Object> decoder = Decoder.nullable(valueDecoder).map(opt -> opt.orElse(null)).map(value -> value == null ? defaultValue : value);
        return (T)Decoder.optionalField(json, fieldName, decoder, defaultValue);
    }

    public static <T> Decoder<T> optionalNullableField(String fieldName, Decoder<? extends T> valueDecoder, T whenFieldMissing, T whenFieldNull) throws JsonDecodingException {
        return json -> Decoder.optionalNullableField(json, fieldName, valueDecoder, whenFieldMissing, whenFieldNull);
    }

    public static <T> T optionalNullableField(Json json, String fieldName, Decoder<? extends T> valueDecoder, T whenFieldMissing, T whenFieldNull) throws JsonDecodingException {
        Decoder<Object> decoder = Decoder.nullable(valueDecoder).map(opt -> opt.orElse(null)).map(value -> value == null ? whenFieldNull : value);
        return (T)Decoder.optionalField(json, fieldName, decoder, whenFieldMissing);
    }

    public static <T> Decoder<T> index(int index, Decoder<? extends T> valueDecoder) throws JsonDecodingException {
        return json -> Decoder.index(json, index, valueDecoder);
    }

    public static <T> T index(Json json, int index, Decoder<? extends T> valueDecoder) throws JsonDecodingException {
        Json.Array jsonArray = Decoder.array(json);
        if (index >= jsonArray.size()) {
            throw JsonDecodingException.atIndex(index, JsonDecodingException.of("expected array index to be in bounds", json));
        }
        try {
            return valueDecoder.decode((Json)jsonArray.get(index));
        }
        catch (JsonDecodingException e) {
            throw JsonDecodingException.atIndex(index, e);
        }
        catch (Exception e) {
            throw JsonDecodingException.atIndex(index, JsonDecodingException.of(e, (Json)jsonArray.get(index)));
        }
    }

    public static <T> Decoder<Optional<T>> nullable(Decoder<? extends T> decoder) {
        return json -> Decoder.oneOf(json, decoder.map(Optional::of), Decoder.of(Decoder::null_).map(__ -> Optional.empty()));
    }

    public static <T> Decoder<T> nullable(Decoder<? extends T> decoder, T defaultValue) {
        return json -> Decoder.oneOf(json, decoder, (Json __) -> defaultValue);
    }

    public static <T> Decoder<T> oneOf(Decoder<? extends T> decoderA, Decoder<? extends T> decoderB) throws JsonDecodingException {
        return json -> Decoder.oneOf(json, decoderA, decoderB);
    }

    public static <T> T oneOf(Json json, Decoder<? extends T> decoderA, Decoder<? extends T> decoderB) throws JsonDecodingException {
        try {
            return decoderA.decode(json);
        }
        catch (JsonDecodingException e1) {
            try {
                return decoderB.decode(json);
            }
            catch (JsonDecodingException e2) {
                JsonDecodingException.OneOf oneOf;
                ArrayList<JsonDecodingException> errors = new ArrayList<JsonDecodingException>();
                if (e1 instanceof JsonDecodingException.OneOf) {
                    oneOf = (JsonDecodingException.OneOf)e1;
                    errors.addAll(oneOf.errors());
                } else {
                    errors.add(e1);
                }
                if (e2 instanceof JsonDecodingException.OneOf) {
                    oneOf = (JsonDecodingException.OneOf)e2;
                    errors.addAll(oneOf.errors());
                } else {
                    errors.add(e2);
                }
                throw JsonDecodingException.multiple(Collections.unmodifiableList(errors));
            }
        }
    }

    @SafeVarargs
    public static <T> Decoder<T> oneOf(Decoder<? extends T> decoderA, Decoder<? extends T> ... decoders) throws JsonDecodingException {
        return json -> Decoder.oneOf(json, decoderA, decoders);
    }

    @SafeVarargs
    public static <T> T oneOf(Json json, Decoder<? extends T> decoderA, Decoder<? extends T> ... decoders) throws JsonDecodingException {
        try {
            return decoderA.decode(json);
        }
        catch (JsonDecodingException e1) {
            ArrayList<JsonDecodingException> errors = new ArrayList<JsonDecodingException>();
            if (e1 instanceof JsonDecodingException.OneOf) {
                JsonDecodingException.OneOf oneOf = (JsonDecodingException.OneOf)e1;
                errors.addAll(oneOf.errors());
            } else {
                errors.add(e1);
            }
            for (Decoder<T> decoder : decoders) {
                try {
                    return decoder.decode(json);
                }
                catch (JsonDecodingException e2) {
                    if (e2 instanceof JsonDecodingException.OneOf) {
                        JsonDecodingException.OneOf oneOf = (JsonDecodingException.OneOf)e2;
                        errors.addAll(oneOf.errors());
                        continue;
                    }
                    errors.add(e2);
                }
            }
            throw JsonDecodingException.multiple(Collections.unmodifiableList(errors));
        }
    }
}

