/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.decode.alpha;

import dev.mccue.json.Json;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class JsonDecodingException
extends RuntimeException {
    private static String indent(String string) {
        return String.join((CharSequence)"\n    ", string.split("\n"));
    }

    private static String getMessageHelp(JsonDecodingException error, ArrayList<String> context) {
        if (error instanceof Field) {
            boolean isSimple;
            Field field = (Field)error;
            Object fieldName = field.fieldName;
            JsonDecodingException err = field.error;
            if (((String)fieldName).isEmpty()) {
                isSimple = false;
            } else {
                isSimple = Character.isAlphabetic(((String)fieldName).charAt(0));
                for (int i = 1; i < ((String)fieldName).length(); ++i) {
                    isSimple = isSimple && (Character.isAlphabetic(((String)fieldName).charAt(i)) || Character.isDigit(((String)fieldName).charAt(i)));
                }
            }
            fieldName = isSimple ? "." + (String)fieldName : "[" + (String)fieldName + "]";
            context.add((String)fieldName);
            return JsonDecodingException.getMessageHelp(err, context);
        }
        if (error instanceof Index) {
            Index index = (Index)error;
            String indexName = "[" + index.index + "]";
            context.add(indexName);
            return JsonDecodingException.getMessageHelp(index.error, context);
        }
        if (error instanceof OneOf) {
            OneOf oneOf = (OneOf)error;
            if (oneOf.errors.isEmpty()) {
                return "Ran into oneOf with no possibilities" + (String)(context.isEmpty() ? "!" : " at json" + String.join((CharSequence)"", context));
            }
            if (oneOf.errors.size() == 1) {
                return JsonDecodingException.getMessageHelp(oneOf.errors.get(0), context);
            }
            String starter = context.isEmpty() ? "oneOf" : "oneOf at json" + String.join((CharSequence)"", context);
            String introduction = starter + " failed in the following " + oneOf.errors.size() + " ways:";
            StringBuilder msg = new StringBuilder(introduction + "\n\n");
            for (int i = 0; i < oneOf.errors.size(); ++i) {
                msg.append("\n\n(");
                msg.append(i + 1);
                msg.append(") ");
                msg.append(JsonDecodingException.indent(JsonDecodingException.getMessage(oneOf.errors.get(i))));
                if (i == oneOf.errors.size() - 1) continue;
                msg.append("\n\n");
            }
            return msg.toString();
        }
        if (error instanceof Failure) {
            Failure failure = (Failure)error;
            String msg = failure.reason;
            Json json = failure.value;
            String introduction = context.isEmpty() ? "Problem with the given value:\n\n" : "Problem with the value at json" + String.join((CharSequence)"", context) + ":\n\n    ";
            return introduction + JsonDecodingException.indent(Json.writeString((Json)json, (Json.WriteOptions)new Json.WriteOptions().withIndentation(4))) + "\n\n" + msg;
        }
        throw new IllegalStateException();
    }

    private static String getMessage(JsonDecodingException error) {
        return JsonDecodingException.getMessageHelp(error, new ArrayList<String>());
    }

    @Override
    public String getMessage() {
        return JsonDecodingException.getMessage(this);
    }

    public static final class Field
    extends JsonDecodingException {
        private final String fieldName;
        private final JsonDecodingException error;

        public Field(String fieldName, JsonDecodingException error) {
            Objects.requireNonNull(fieldName, "fieldName must not be null");
            Objects.requireNonNull(error, "error must not be null");
            this.fieldName = fieldName;
            this.error = error;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public JsonDecodingException error() {
            return this.error;
        }
    }

    public static final class Index
    extends JsonDecodingException {
        private final int index;
        private final JsonDecodingException error;

        public Index(int index, JsonDecodingException error) {
            Objects.requireNonNull(error);
            this.index = index;
            this.error = error;
        }

        public int getIndex() {
            return this.index;
        }

        public JsonDecodingException error() {
            return this.error;
        }
    }

    public static final class OneOf
    extends JsonDecodingException {
        private final List<JsonDecodingException> errors;

        public OneOf(List<JsonDecodingException> errors) {
            Objects.requireNonNull(errors, "errors must not be null");
            errors.forEach(error -> Objects.requireNonNull(error, "every error must not be null"));
            this.errors = List.copyOf(errors);
        }

        public List<JsonDecodingException> errors() {
            return this.errors;
        }
    }

    public static final class Failure
    extends JsonDecodingException {
        private final String reason;
        private final Json value;

        public Failure(String reason, Json value) {
            this.reason = reason;
            this.value = value;
        }

        public String reason() {
            return this.reason;
        }

        public Json value() {
            return this.value;
        }
    }
}

