/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.jdk.httpserver.regexrouter;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import dev.mccue.jdk.httpserver.regexrouter.InternalErrorHandler;
import dev.mccue.jdk.httpserver.regexrouter.NotFoundHandler;
import dev.mccue.jdk.httpserver.regexrouter.RouteParams;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexRouter
implements HttpHandler {
    private final List<Mapping> mappings;
    private final ErrorHandler errorHandler;
    private final HttpHandler notFoundHandler;

    private RegexRouter(Builder builder) {
        this.mappings = builder.mappings;
        this.errorHandler = builder.errorHandler;
        this.notFoundHandler = builder.notFoundHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        for (Mapping mapping : this.mappings) {
            String method = exchange.getRequestMethod();
            Pattern pattern = mapping.routePattern();
            Matcher matcher = pattern.matcher(exchange.getRequestURI().getPath());
            if (!method.equalsIgnoreCase(mapping.method) || !matcher.matches()) continue;
            new MatcherRouteParams(matcher).set(exchange);
            try {
                mapping.handler.handle(exchange);
            }
            catch (Throwable t) {
                this.errorHandler.handle(t, exchange);
            }
            return;
        }
        this.notFoundHandler.handle(exchange);
    }

    public static final class Builder {
        private final List<Mapping> mappings = new ArrayList<Mapping>();
        private ErrorHandler errorHandler = new InternalErrorHandler();
        private HttpHandler notFoundHandler = new NotFoundHandler();

        private Builder() {
        }

        public Builder route(String method, Pattern routePattern, HttpHandler handler) {
            return this.route(List.of(method), routePattern, handler);
        }

        public Builder route(List<String> methods, Pattern routePattern, HttpHandler handler) {
            Objects.requireNonNull(methods);
            Objects.requireNonNull(routePattern);
            Objects.requireNonNull(handler);
            if (!methods.isEmpty()) {
                for (String method : methods) {
                    this.mappings.add(new Mapping(method.toLowerCase(), routePattern, handler));
                }
            }
            return this;
        }

        public Builder get(Pattern routePattern, HttpHandler handler) {
            return this.route("get", routePattern, handler);
        }

        public Builder post(Pattern routePattern, HttpHandler handler) {
            return this.route("get", routePattern, handler);
        }

        public Builder patch(Pattern routePattern, HttpHandler handler) {
            return this.route("patch", routePattern, handler);
        }

        public Builder put(Pattern routePattern, HttpHandler handler) {
            return this.route("put", routePattern, handler);
        }

        public Builder head(Pattern routePattern, HttpHandler handler) {
            return this.route("head", routePattern, handler);
        }

        public Builder delete(Pattern routePattern, HttpHandler handler) {
            return this.route("delete", routePattern, handler);
        }

        public Builder options(Pattern routePattern, HttpHandler handler) {
            return this.route("options", routePattern, handler);
        }

        public Builder errorHandler(Function<Throwable, HttpHandler> errorHandler) {
            this.errorHandler = (t, exchange) -> ((HttpHandler)errorHandler.apply(t)).handle(exchange);
            return this;
        }

        public Builder errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder notFoundHandler(HttpHandler handler) {
            this.notFoundHandler = handler;
            return this;
        }

        public RegexRouter build() {
            return new RegexRouter(this);
        }
    }

    public static interface ErrorHandler {
        public void handle(Throwable var1, HttpExchange var2) throws IOException;
    }

    private record Mapping(String method, Pattern routePattern, HttpHandler handler) {
    }

    record MatcherRouteParams(Matcher matcher) implements RouteParams
    {
        @Override
        public Optional<String> param(int pos) {
            if (this.matcher.groupCount() > pos - 1 || pos < 0) {
                return Optional.empty();
            }
            return Optional.of(URLDecoder.decode(this.matcher.group(pos + 1), StandardCharsets.UTF_8));
        }

        @Override
        public Optional<String> param(String name) {
            try {
                String namedGroup = this.matcher.group(name);
                if (namedGroup == null) {
                    return Optional.empty();
                }
                return Optional.of(URLDecoder.decode(namedGroup, StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException ex) {
                return Optional.empty();
            }
        }
    }
}

