/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.primitives;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.primitives.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.primitives.VisibleForTesting;
import java.util.Arrays;
import java.util.Comparator;

@ElementTypesAreNonnullByDefault
public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;
    public static final byte MAX_VALUE = -1;
    private static final int UNSIGNED_MASK = 255;

    private UnsignedBytes() {
    }

    public static int toInt(byte value) {
        return value & 0xFF;
    }

    @CanIgnoreReturnValue
    public static byte checkedCast(long value) {
        Preconditions.checkArgument((value >> 8 == 0L ? 1 : 0) != 0, (String)"out of range: %s", (long)value);
        return (byte)value;
    }

    public static byte saturatedCast(long value) {
        if (value > (long)UnsignedBytes.toInt((byte)-1)) {
            return -1;
        }
        if (value < 0L) {
            return 0;
        }
        return (byte)value;
    }

    public static int compare(byte a, byte b) {
        return UnsignedBytes.toInt(a) - UnsignedBytes.toInt(b);
    }

    public static byte min(byte ... array) {
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0);
        int min = UnsignedBytes.toInt(array[0]);
        for (int i = 1; i < array.length; ++i) {
            int next = UnsignedBytes.toInt(array[i]);
            if (next >= min) continue;
            min = next;
        }
        return (byte)min;
    }

    public static byte max(byte ... array) {
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0);
        int max = UnsignedBytes.toInt(array[0]);
        for (int i = 1; i < array.length; ++i) {
            int next = UnsignedBytes.toInt(array[i]);
            if (next <= max) continue;
            max = next;
        }
        return (byte)max;
    }

    public static String toString(byte x) {
        return UnsignedBytes.toString(x, 10);
    }

    public static String toString(byte x, int radix) {
        Preconditions.checkArgument((radix >= 2 && radix <= 36 ? 1 : 0) != 0, (String)"radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", (int)radix);
        return Integer.toString(UnsignedBytes.toInt(x), radix);
    }

    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string) {
        return UnsignedBytes.parseUnsignedByte(string, 10);
    }

    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string, int radix) {
        int parse = Integer.parseInt((String)Preconditions.checkNotNull((Object)string), radix);
        if (parse >> 8 == 0) {
            return (byte)parse;
        }
        throw new NumberFormatException("out of range: " + parse);
    }

    public static String join(String separator, byte ... array) {
        Preconditions.checkNotNull((Object)separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * (3 + separator.length()));
        builder.append(UnsignedBytes.toInt(array[0]));
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(UnsignedBytes.toString(array[i]));
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    private static byte flip(byte b) {
        return (byte)(b ^ 0x80);
    }

    public static void sort(byte[] array) {
        Preconditions.checkNotNull((Object)array);
        UnsignedBytes.sort(array, 0, array.length);
    }

    public static void sort(byte[] array, int fromIndex, int toIndex) {
        int i;
        Preconditions.checkNotNull((Object)array);
        Preconditions.checkPositionIndexes((int)fromIndex, (int)toIndex, (int)array.length);
        for (i = fromIndex; i < toIndex; ++i) {
            array[i] = UnsignedBytes.flip(array[i]);
        }
        Arrays.sort(array, fromIndex, toIndex);
        for (i = fromIndex; i < toIndex; ++i) {
            array[i] = UnsignedBytes.flip(array[i]);
        }
    }

    public static void sortDescending(byte[] array) {
        Preconditions.checkNotNull((Object)array);
        UnsignedBytes.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(byte[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull((Object)array);
        Preconditions.checkPositionIndexes((int)fromIndex, (int)toIndex, (int)array.length);
        int i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array[n] = (byte)(array[n] ^ 0x7F);
        }
        Arrays.sort(array, fromIndex, toIndex);
        i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array[n] = (byte)(array[n] ^ 0x7F);
        }
    }

    @VisibleForTesting
    static class LexicographicalComparatorHolder {
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();

        LexicographicalComparatorHolder() {
        }

        static Comparator<byte[]> getBestComparator() {
            return UnsignedBytes.lexicographicalComparatorJavaImpl();
        }

        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] left, byte[] right) {
                int minLength = Math.min(left.length, right.length);
                for (int i = 0; i < minLength; ++i) {
                    int result = UnsignedBytes.compare(left[i], right[i]);
                    if (result == 0) continue;
                    return result;
                }
                return left.length - right.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (pure Java version)";
            }
        }
    }
}

