/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.net;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.concurrent.LazyInit;
import dev.mccue.guava.base.Ascii;
import dev.mccue.guava.base.CharMatcher;
import dev.mccue.guava.base.Joiner;
import dev.mccue.guava.base.Optional;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.base.Splitter;
import dev.mccue.guava.collect.ImmutableList;
import dev.mccue.guava.net.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.net.thirdparty.publicsuffix.PublicSuffixPatterns;
import dev.mccue.guava.net.thirdparty.publicsuffix.PublicSuffixType;
import dev.mccue.jsr305.CheckForNull;
import java.util.List;

@Immutable
@ElementTypesAreNonnullByDefault
public final class InternetDomainName {
    private static final CharMatcher DOTS_MATCHER = CharMatcher.anyOf((CharSequence)".\u3002\uff0e\uff61");
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    private static final Joiner DOT_JOINER = Joiner.on((char)'.');
    private static final int NO_SUFFIX_FOUND = -1;
    private static final int SUFFIX_NOT_INITIALIZED = -2;
    private static final int MAX_PARTS = 127;
    private static final int MAX_LENGTH = 253;
    private static final int MAX_DOMAIN_PART_LENGTH = 63;
    private final String name;
    private final ImmutableList<String> parts;
    @LazyInit
    private int publicSuffixIndexCache = -2;
    @LazyInit
    private int registrySuffixIndexCache = -2;
    private static final CharMatcher DASH_MATCHER = CharMatcher.anyOf((CharSequence)"-_");
    private static final CharMatcher DIGIT_MATCHER = CharMatcher.inRange((char)'0', (char)'9');
    private static final CharMatcher LETTER_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z'));
    private static final CharMatcher PART_CHAR_MATCHER = DIGIT_MATCHER.or(LETTER_MATCHER).or(DASH_MATCHER);

    InternetDomainName(String name) {
        name = Ascii.toLowerCase((String)DOTS_MATCHER.replaceFrom((CharSequence)name, '.'));
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        Preconditions.checkArgument((name.length() <= 253 ? 1 : 0) != 0, (String)"Domain name too long: '%s':", (Object)name);
        this.name = name;
        this.parts = ImmutableList.copyOf((Iterable)DOT_SPLITTER.split((CharSequence)name));
        Preconditions.checkArgument((this.parts.size() <= 127 ? 1 : 0) != 0, (String)"Domain has too many parts: '%s'", (Object)name);
        Preconditions.checkArgument((boolean)InternetDomainName.validateSyntax(this.parts), (String)"Not a valid domain name: '%s'", (Object)name);
    }

    private int publicSuffixIndex() {
        int publicSuffixIndexLocal = this.publicSuffixIndexCache;
        if (publicSuffixIndexLocal == -2) {
            this.publicSuffixIndexCache = publicSuffixIndexLocal = this.findSuffixOfType((Optional<PublicSuffixType>)Optional.absent());
        }
        return publicSuffixIndexLocal;
    }

    private int registrySuffixIndex() {
        int registrySuffixIndexLocal = this.registrySuffixIndexCache;
        if (registrySuffixIndexLocal == -2) {
            this.registrySuffixIndexCache = registrySuffixIndexLocal = this.findSuffixOfType((Optional<PublicSuffixType>)Optional.of((Object)((Object)PublicSuffixType.REGISTRY)));
        }
        return registrySuffixIndexLocal;
    }

    private int findSuffixOfType(Optional<PublicSuffixType> desiredType) {
        int partsSize = this.parts.size();
        for (int i = 0; i < partsSize; ++i) {
            String ancestorName = DOT_JOINER.join((Iterable)this.parts.subList(i, partsSize));
            if (i > 0 && InternetDomainName.matchesType(desiredType, (Optional<PublicSuffixType>)Optional.fromNullable((Object)((Object)((PublicSuffixType)((Object)PublicSuffixPatterns.UNDER.get((Object)ancestorName))))))) {
                return i - 1;
            }
            if (InternetDomainName.matchesType(desiredType, (Optional<PublicSuffixType>)Optional.fromNullable((Object)((Object)((PublicSuffixType)((Object)PublicSuffixPatterns.EXACT.get((Object)ancestorName))))))) {
                return i;
            }
            if (!PublicSuffixPatterns.EXCLUDED.containsKey((Object)ancestorName)) continue;
            return i + 1;
        }
        return -1;
    }

    @CanIgnoreReturnValue
    public static InternetDomainName from(String domain) {
        return new InternetDomainName((String)Preconditions.checkNotNull((Object)domain));
    }

    private static boolean validateSyntax(List<String> parts) {
        int lastIndex = parts.size() - 1;
        if (!InternetDomainName.validatePart(parts.get(lastIndex), true)) {
            return false;
        }
        for (int i = 0; i < lastIndex; ++i) {
            String part = parts.get(i);
            if (InternetDomainName.validatePart(part, false)) continue;
            return false;
        }
        return true;
    }

    private static boolean validatePart(String part, boolean isFinalPart) {
        if (part.length() < 1 || part.length() > 63) {
            return false;
        }
        String asciiChars = CharMatcher.ascii().retainFrom((CharSequence)part);
        if (!PART_CHAR_MATCHER.matchesAllOf((CharSequence)asciiChars)) {
            return false;
        }
        if (DASH_MATCHER.matches(part.charAt(0)) || DASH_MATCHER.matches(part.charAt(part.length() - 1))) {
            return false;
        }
        return !isFinalPart || !DIGIT_MATCHER.matches(part.charAt(0));
    }

    public ImmutableList<String> parts() {
        return this.parts;
    }

    public boolean isPublicSuffix() {
        return this.publicSuffixIndex() == 0;
    }

    public boolean hasPublicSuffix() {
        return this.publicSuffixIndex() != -1;
    }

    @CheckForNull
    public InternetDomainName publicSuffix() {
        return this.hasPublicSuffix() ? this.ancestor(this.publicSuffixIndex()) : null;
    }

    public boolean isUnderPublicSuffix() {
        return this.publicSuffixIndex() > 0;
    }

    public boolean isTopPrivateDomain() {
        return this.publicSuffixIndex() == 1;
    }

    public InternetDomainName topPrivateDomain() {
        if (this.isTopPrivateDomain()) {
            return this;
        }
        Preconditions.checkState((boolean)this.isUnderPublicSuffix(), (String)"Not under a public suffix: %s", (Object)this.name);
        return this.ancestor(this.publicSuffixIndex() - 1);
    }

    public boolean isRegistrySuffix() {
        return this.registrySuffixIndex() == 0;
    }

    public boolean hasRegistrySuffix() {
        return this.registrySuffixIndex() != -1;
    }

    @CheckForNull
    public InternetDomainName registrySuffix() {
        return this.hasRegistrySuffix() ? this.ancestor(this.registrySuffixIndex()) : null;
    }

    public boolean isUnderRegistrySuffix() {
        return this.registrySuffixIndex() > 0;
    }

    public boolean isTopDomainUnderRegistrySuffix() {
        return this.registrySuffixIndex() == 1;
    }

    public InternetDomainName topDomainUnderRegistrySuffix() {
        if (this.isTopDomainUnderRegistrySuffix()) {
            return this;
        }
        Preconditions.checkState((boolean)this.isUnderRegistrySuffix(), (String)"Not under a registry suffix: %s", (Object)this.name);
        return this.ancestor(this.registrySuffixIndex() - 1);
    }

    public boolean hasParent() {
        return this.parts.size() > 1;
    }

    public InternetDomainName parent() {
        Preconditions.checkState((boolean)this.hasParent(), (String)"Domain '%s' has no parent", (Object)this.name);
        return this.ancestor(1);
    }

    private InternetDomainName ancestor(int levels) {
        return InternetDomainName.from(DOT_JOINER.join((Iterable)this.parts.subList(levels, this.parts.size())));
    }

    public InternetDomainName child(String leftParts) {
        return InternetDomainName.from((String)Preconditions.checkNotNull((Object)leftParts) + "." + this.name);
    }

    public static boolean isValid(String name) {
        try {
            InternetDomainName unused = InternetDomainName.from(name);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean matchesType(Optional<PublicSuffixType> desiredType, Optional<PublicSuffixType> actualType) {
        return desiredType.isPresent() ? desiredType.equals(actualType) : actualType.isPresent();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof InternetDomainName) {
            InternetDomainName that = (InternetDomainName)object;
            return this.name.equals(that.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

