/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.concurrent;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.concurrent.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.concurrent.LazyLogger;
import dev.mccue.jsr305.CheckForNull;
import java.util.concurrent.Executor;

@ElementTypesAreNonnullByDefault
public final class ExecutionList {
    private static final LazyLogger log = new LazyLogger(ExecutionList.class);
    @CheckForNull
    @GuardedBy(value="this")
    private RunnableExecutorPair runnables;
    @GuardedBy(value="this")
    private boolean executed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable runnable, Executor executor) {
        Preconditions.checkNotNull((Object)runnable, (Object)"Runnable was null.");
        Preconditions.checkNotNull((Object)executor, (Object)"Executor was null.");
        ExecutionList executionList = this;
        synchronized (executionList) {
            if (!this.executed) {
                this.runnables = new RunnableExecutorPair(runnable, executor, this.runnables);
                return;
            }
        }
        ExecutionList.executeListener(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        RunnableExecutorPair list;
        ExecutionList executionList = this;
        synchronized (executionList) {
            if (this.executed) {
                return;
            }
            this.executed = true;
            list = this.runnables;
            this.runnables = null;
        }
        RunnableExecutorPair reversedList = null;
        while (list != null) {
            RunnableExecutorPair tmp = list;
            list = list.next;
            tmp.next = reversedList;
            reversedList = tmp;
        }
        while (reversedList != null) {
            ExecutionList.executeListener(reversedList.runnable, reversedList.executor);
            reversedList = reversedList.next;
        }
    }

    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
        }
        catch (Exception e) {
            log.get().log(System.Logger.Level.ERROR, "RuntimeException while executing runnable " + runnable + " with executor " + executor, (Throwable)e);
        }
    }

    private static final class RunnableExecutorPair {
        final Runnable runnable;
        final Executor executor;
        @CheckForNull
        RunnableExecutorPair next;

        RunnableExecutorPair(Runnable runnable, Executor executor, @CheckForNull RunnableExecutorPair next) {
            this.runnable = runnable;
            this.executor = executor;
            this.next = next;
        }
    }
}

