/*
 * Decompiled with CFR 0.152.
 */
package dev.mardroemmar.truthext.currency;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.util.Currency;
import java.util.Locale;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.MAINTAINED)
public class CurrencySubject
extends Subject {
    private final @Nullable Currency actual;

    public static CurrencySubject assertThat(@Nullable Currency actual) {
        return (CurrencySubject)Truth.assertAbout(CurrencySubject.currencies()).that((Object)actual);
    }

    public static Subject.Factory<CurrencySubject, Currency> currencies() {
        return CurrencySubject::new;
    }

    private CurrencySubject(FailureMetadata metadata, @Nullable Currency actual) {
        super(metadata, (Object)actual);
        this.actual = actual;
    }

    public StringSubject currencyCode() {
        return this.check("getCurrencyCode()", new Object[0]).that(this.nonNull().getCurrencyCode());
    }

    public StringSubject displayName() {
        return this.check("getDisplayName()", new Object[0]).that(this.nonNull().getDisplayName());
    }

    public StringSubject displayName(Locale locale) {
        return this.check("getDisplayName()", new Object[0]).that(this.nonNull().getDisplayName(locale));
    }

    public IntegerSubject numericCode() {
        return this.check("getNumericCode()", new Object[0]).that(Integer.valueOf(this.nonNull().getNumericCode()));
    }

    public StringSubject symbol() {
        return this.check("getSymbol()", new Object[0]).that(this.nonNull().getSymbol());
    }

    public StringSubject symbol(Locale locale) {
        return this.check("getSymbol()", new Object[0]).that(this.nonNull().getSymbol(locale));
    }

    public IntegerSubject defaultFractionDigits() {
        return this.check("getDefaultFractionDigits()", new Object[0]).that(Integer.valueOf(this.nonNull().getDefaultFractionDigits()));
    }

    private Currency nonNull() {
        if (this.actual != null) {
            return this.actual;
        }
        this.failWithActual(Fact.simpleFact((String)"expected currency to be non-null"), new Fact[0]);
        throw new AssertionError((Object)"unreachable");
    }
}

