/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.database;

import dev.lydtech.component.framework.configuration.TestcontainersConfiguration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbClient {
    private static final Logger log = LoggerFactory.getLogger(MariaDbClient.class);
    private static MariaDbClient instance;
    private static String dbHostAndPortUrl;

    private MariaDbClient() {
        String mariaDbHost = Optional.ofNullable(System.getProperty("docker.host")).orElse("localhost");
        String mariaDbPort = Optional.ofNullable(System.getProperty("mariadb.mapped.port")).orElseThrow(() -> new RuntimeException("mariadb.mapped.port property not found"));
        dbHostAndPortUrl = "jdbc:mariadb://" + mariaDbHost + ":" + mariaDbPort + "/";
    }

    public static synchronized MariaDbClient getInstance() {
        if (instance == null) {
            instance = new MariaDbClient();
        }
        return instance;
    }

    public static Connection getConnection() throws Exception {
        return MariaDbClient.getConnection(TestcontainersConfiguration.MARIADB_DATABASE_NAME, TestcontainersConfiguration.MARIADB_USERNAME, TestcontainersConfiguration.MARIADB_PASSWORD);
    }

    public static Connection getConnection(String databaseName, String username, String password) throws Exception {
        String dbUrl = dbHostAndPortUrl + databaseName;
        Connection connection = DriverManager.getConnection(dbUrl, username, password);
        log.debug("Connected to MariaDB at: " + dbUrl);
        return connection;
    }

    public static void close(Connection connection) throws Exception {
        if (connection != null && !connection.isClosed()) {
            connection.close();
        }
    }

    public static String getDbHostAndPortUrl() {
        return dbHostAndPortUrl;
    }
}

