/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.localstack;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import dev.lydtech.component.framework.configuration.TestcontainersConfiguration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDbClient {
    private static final Logger log = LoggerFactory.getLogger(DynamoDbClient.class);
    private static DynamoDbClient instance;
    private String baseUrl;

    private DynamoDbClient() {
        String localstackHost = Optional.ofNullable(System.getProperty("docker.host")).orElse("localhost");
        String localstackPort = Optional.ofNullable(System.getProperty("localstack.mapped.port")).orElseThrow(() -> new RuntimeException("localstack.mapped.port property not found"));
        this.baseUrl = "http://" + localstackHost + ":" + localstackPort;
        log.info("DynamoDB base URL is: " + this.baseUrl);
    }

    public static synchronized DynamoDbClient getInstance() {
        if (TestcontainersConfiguration.LOCALSTACK_SERVICES == null || !TestcontainersConfiguration.LOCALSTACK_SERVICES.contains("dynamodb")) {
            throw new RuntimeException("'dynamodb' not specified in 'localstack.services'.  'localstack.services' is: " + TestcontainersConfiguration.LOCALSTACK_SERVICES);
        }
        if (instance == null) {
            instance = new DynamoDbClient();
        }
        return instance;
    }

    public void createTable(Class<?> clazz, String region) {
        this.createTable(clazz, region, "key", "secret-key", 1L, 1L);
    }

    public void createTable(Class<?> clazz, String region, String accessKey, String secretKey, Long readCapacityUnits, Long writeCapacityUnits) {
        try {
            AmazonDynamoDB amazonDynamoDB = (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.baseUrl, region))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey)))).build();
            DynamoDBMapper dynamoDBMapper = new DynamoDBMapper(amazonDynamoDB);
            CreateTableRequest tableRequest = dynamoDBMapper.generateCreateTableRequest(clazz);
            tableRequest.setProvisionedThroughput(new ProvisionedThroughput(readCapacityUnits, writeCapacityUnits));
            amazonDynamoDB.createTable(tableRequest);
        }
        catch (ResourceInUseException e) {
            log.info("Table already created: " + e.getMessage());
        }
    }
}

