/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.database;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbClient {
    private static final Logger log = LoggerFactory.getLogger(MongoDbClient.class);
    private static MongoDbClient instance;
    private static String dbUrl;

    private MongoDbClient() {
        String mongoDbHost = Optional.ofNullable(System.getProperty("docker.host")).orElse("localhost");
        String mongoDbPort = Optional.ofNullable(System.getProperty("mongodb.mapped.port")).orElseThrow(() -> new RuntimeException("mongodb.mapped.port property not found"));
        dbUrl = "mongodb://" + mongoDbHost + ":" + mongoDbPort + "/";
    }

    public static synchronized MongoDbClient getInstance() {
        if (instance == null) {
            instance = new MongoDbClient();
        }
        return instance;
    }

    public static MongoClient getMongoClient() {
        ConnectionString connectionString = new ConnectionString(dbUrl);
        log.debug("Connected to MongoDB at: " + dbUrl);
        return MongoClients.create((ConnectionString)connectionString);
    }

    public static void close(MongoClient mongoClient) {
        if (mongoClient != null) {
            mongoClient.close();
        }
    }

    public static String getDbUrl() {
        return dbUrl;
    }
}

