/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.database;

import dev.lydtech.component.framework.extension.TestContainersConfiguration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresClient {
    private static final Logger log = LoggerFactory.getLogger(PostgresClient.class);
    private static PostgresClient instance;
    private static String dbHostAndPortUrl;

    private PostgresClient() {
        String postgresHost = Optional.ofNullable(System.getProperty("docker.host")).orElse("localhost");
        String postgresPort = Optional.ofNullable(System.getProperty("postgres.mapped.port")).orElseThrow(() -> new RuntimeException("postgres.mapped.port property not found"));
        dbHostAndPortUrl = "jdbc:postgresql://" + postgresHost + ":" + postgresPort + "/";
    }

    public static synchronized PostgresClient getInstance() {
        if (instance == null) {
            instance = new PostgresClient();
        }
        return instance;
    }

    public static Connection getConnection() throws Exception {
        return PostgresClient.getConnection(TestContainersConfiguration.POSTGRES_DATABASE_NAME, TestContainersConfiguration.POSTGRES_SCHEMA_NAME, TestContainersConfiguration.POSTGRES_USERNAME, TestContainersConfiguration.POSTGRES_PASSWORD);
    }

    public static Connection getConnection(String databaseName, String schemaName, String username, String password) throws Exception {
        String dbUrl = dbHostAndPortUrl + databaseName + "?currentSchema=" + schemaName;
        Connection connection = DriverManager.getConnection(dbUrl, username, password);
        log.debug("Connected to Postgres at: " + dbUrl);
        return connection;
    }

    public static void close(Connection connection) throws Exception {
        if (connection != null && !connection.isClosed()) {
            connection.close();
        }
    }

    public static String getDbHostAndPortUrl() {
        return dbHostAndPortUrl;
    }
}

