/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.conduktor;

import dev.lydtech.component.framework.client.conduktor.BrokenBrokerErrorType;
import dev.lydtech.component.framework.client.conduktor.ChaosType;
import dev.lydtech.component.framework.client.conduktor.GatewayInjectChaosRequest;
import dev.lydtech.component.framework.mapper.JsonMapper;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.EnumSet;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConduktorGatewayClient {
    private static final Logger log = LoggerFactory.getLogger(ConduktorGatewayClient.class);
    private RequestSpecification requestSpec;
    private static ConduktorGatewayClient instance;

    private ConduktorGatewayClient() {
        String conduktorGatewayHost = Optional.ofNullable(System.getProperty("docker.host")).orElse("localhost");
        String conduktorGatewayPort = Optional.ofNullable(System.getProperty("conduktorgateway.mapped.port")).orElseThrow(() -> new RuntimeException("conduktorgateway.mapped.port property not found"));
        String baseUrl = "http://" + conduktorGatewayHost + ":" + conduktorGatewayPort;
        log.info("Conduktor Gateway base URL is: " + baseUrl);
        this.requestSpec = new RequestSpecBuilder().setBaseUri(baseUrl).build();
    }

    public static synchronized ConduktorGatewayClient getInstance() {
        if (instance == null) {
            instance = new ConduktorGatewayClient();
        }
        return instance;
    }

    public void simulateBrokenBroker(int failureRatePercentage, BrokenBrokerErrorType brokenBrokerErrorType) {
        GatewayInjectChaosRequest.ErrorMap.ErrorMapBuilder errorMapBuilder = GatewayInjectChaosRequest.ErrorMap.builder();
        if (brokenBrokerErrorType.getErrorMapType().equals("PRODUCE")) {
            errorMapBuilder.PRODUCE(brokenBrokerErrorType.name());
        } else {
            errorMapBuilder.FETCH(brokenBrokerErrorType.name());
        }
        this.injectChaos(ChaosType.BROKEN_BROKER, failureRatePercentage, errorMapBuilder.build(), null);
    }

    public void simulateLeaderElection(int failureRatePercentage) {
        this.injectChaos(ChaosType.LEADER_ELECTION, failureRatePercentage, null, null);
    }

    public void simulateSlowBroker(int failureRatePercentage, int minLatencyMs, int maxLatencyMs) {
        this.injectChaos(ChaosType.SLOW_BROKER, failureRatePercentage, null, Latency.builder().minLatencyMs(minLatencyMs).maxLatencyMs(maxLatencyMs).build());
    }

    private void injectChaos(ChaosType chaosType, int failureRatePercentage, GatewayInjectChaosRequest.ErrorMap errorMap, Latency latency) {
        GatewayInjectChaosRequest gatewayInjectChaosRequest = GatewayInjectChaosRequest.builder().name(chaosType.name()).pluginClass("io.conduktor.gateway.interceptor.chaos." + chaosType.getPluginClassName()).priority(100).config(GatewayInjectChaosRequest.Config.builder().rateInPercent(failureRatePercentage).errorMap(errorMap).minLatencyMs(latency != null ? Integer.valueOf(latency.getMinLatencyMs()) : null).maxLatencyMs(latency != null ? Integer.valueOf(latency.getMaxLatencyMs()) : null).build()).build();
        String request = JsonMapper.writeToJson(gatewayInjectChaosRequest);
        log.info("Injecting " + chaosType.name() + " chaos with request: " + request);
        ((ValidatableResponse)((Response)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).body(request).contentType("application/json").auth().basic("admin", "conduktor").post("/admin/interceptors/v1/vcluster/passthrough/interceptor/" + chaosType.getInterceptorPath(), new Object[0])).then()).extract().response()).then()).statusCode(201);
    }

    public void reset() {
        EnumSet.allOf(ChaosType.class).forEach(chaosType -> this.reset((ChaosType)((Object)chaosType)));
    }

    public int reset(ChaosType chaosType) {
        log.info("Resetting Conduktor Gateway for chaos type: " + chaosType.name());
        return ((Response)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).auth().basic("admin", "conduktor").delete("/admin/interceptors/v1/vcluster/passthrough/interceptor/" + chaosType.getInterceptorPath(), new Object[0])).then()).extract().response()).getStatusCode();
    }

    private static class Latency {
        private int minLatencyMs;
        private int maxLatencyMs;

        Latency(int minLatencyMs, int maxLatencyMs) {
            this.minLatencyMs = minLatencyMs;
            this.maxLatencyMs = maxLatencyMs;
        }

        public static LatencyBuilder builder() {
            return new LatencyBuilder();
        }

        public int getMinLatencyMs() {
            return this.minLatencyMs;
        }

        public int getMaxLatencyMs() {
            return this.maxLatencyMs;
        }

        public static class LatencyBuilder {
            private int minLatencyMs;
            private int maxLatencyMs;

            LatencyBuilder() {
            }

            public LatencyBuilder minLatencyMs(int minLatencyMs) {
                this.minLatencyMs = minLatencyMs;
                return this;
            }

            public LatencyBuilder maxLatencyMs(int maxLatencyMs) {
                this.maxLatencyMs = maxLatencyMs;
                return this;
            }

            public Latency build() {
                return new Latency(this.minLatencyMs, this.maxLatencyMs);
            }

            public String toString() {
                return "ConduktorGatewayClient.Latency.LatencyBuilder(minLatencyMs=" + this.minLatencyMs + ", maxLatencyMs=" + this.maxLatencyMs + ")";
            }
        }
    }
}

