/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.extension;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import dev.lydtech.component.framework.extension.TestContainersConfiguration;
import dev.lydtech.component.framework.resource.Resource;
import io.debezium.testing.testcontainers.DebeziumContainer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public final class TestContainersManager {
    private static final Logger log = LoggerFactory.getLogger(TestContainersManager.class);
    private Network network;
    private List<GenericContainer> serviceContainers = new ArrayList<GenericContainer>(1);
    private List<GenericContainer> additionalContainers;
    private GenericContainer postgresContainer;
    private List<KafkaContainer> kafkaContainers;
    private GenericContainer zookeeperContainer;
    private DebeziumContainer debeziumContainer;
    private GenericContainer kafkaSchemaRegistryContainer;
    private GenericContainer wiremockContainer;
    private GenericContainer localstackContainer;
    private GenericContainer controlCenterContainer;
    private GenericContainer conduktorContainer;

    private TestContainersManager() {
    }

    protected static void initialise() {
        TestContainersManager manager = new TestContainersManager();
        log.info("Creating test containers...");
        manager.createContainers();
        log.info("Starting test containers...");
        manager.startContainers();
        log.info("Started test containers.");
    }

    private void createContainers() {
        if (TestContainersConfiguration.SERVICE_INSTANCE_COUNT < 1) {
            throw new RuntimeException("At least one service container should be started");
        }
        this.network = Network.newNetwork();
        if (TestContainersConfiguration.POSTGRES_ENABLED) {
            this.postgresContainer = this.createPostgresContainer();
        }
        if (TestContainersConfiguration.KAFKA_ENABLED) {
            if (TestContainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR > TestContainersConfiguration.KAFKA_BROKER_COUNT) {
                throw new RuntimeException("kafka.topic.replication.factor: " + TestContainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR + " - must not be greater than kafka.broker.count: " + TestContainersConfiguration.KAFKA_BROKER_COUNT);
            }
            if (TestContainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS > TestContainersConfiguration.KAFKA_BROKER_COUNT) {
                throw new RuntimeException("kafka.min.insync.replicas: " + TestContainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS + " - must not be greater than kafka.broker.count: " + TestContainersConfiguration.KAFKA_BROKER_COUNT);
            }
            if (TestContainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS > TestContainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR) {
                throw new RuntimeException("kafka.min.insync.replicas: " + TestContainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS + " - must not be greater than kafka.topic.replication.factor: " + TestContainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR);
            }
            if (TestContainersConfiguration.KAFKA_BROKER_COUNT > 1) {
                this.zookeeperContainer = this.createZookeeperContainer();
            }
            this.kafkaContainers = TestContainersConfiguration.KAFKA_CONTROL_CENTER_ENABLED && TestContainersConfiguration.KAFKA_CONTROL_CENTER_EXPORT_METRICS_ENABLED ? IntStream.range(1, TestContainersConfiguration.KAFKA_BROKER_COUNT + 1).mapToObj(this::createKafkaServerContainer).collect(Collectors.toList()) : IntStream.range(1, TestContainersConfiguration.KAFKA_BROKER_COUNT + 1).mapToObj(this::createKafkaContainer).collect(Collectors.toList());
        }
        if (TestContainersConfiguration.DEBEZIUM_ENABLED) {
            if (!TestContainersConfiguration.KAFKA_ENABLED || !TestContainersConfiguration.POSTGRES_ENABLED) {
                throw new RuntimeException("Kafka and Postgres must be enabled in order to use Debezium.");
            }
            this.debeziumContainer = this.createDebeziumContainer();
        }
        if (TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_ENABLED) {
            if (!TestContainersConfiguration.KAFKA_ENABLED) {
                throw new RuntimeException("Kafka must be enabled in order to use Kafka schema registry.");
            }
            this.kafkaSchemaRegistryContainer = this.createKafkaSchemaRegistryContainer();
        }
        if (TestContainersConfiguration.WIREMOCK_ENABLED) {
            this.wiremockContainer = this.createWiremockContainer();
        }
        if (TestContainersConfiguration.LOCALSTACK_ENABLED) {
            this.localstackContainer = this.createLocalstackContainer();
        }
        if (TestContainersConfiguration.KAFKA_CONTROL_CENTER_ENABLED) {
            if (!TestContainersConfiguration.KAFKA_ENABLED) {
                throw new RuntimeException("Kafka must be enabled in order to use Control Center.");
            }
            this.controlCenterContainer = this.createControlCenterContainer();
        }
        if (TestContainersConfiguration.CONDUKTOR_ENABLED) {
            if (!TestContainersConfiguration.KAFKA_ENABLED) {
                throw new RuntimeException("Kafka must be enabled in order to use Conduktor.");
            }
            this.conduktorContainer = this.createConduktorContainer();
        }
        this.serviceContainers = IntStream.range(1, TestContainersConfiguration.SERVICE_INSTANCE_COUNT + 1).mapToObj(this::createServiceContainer).collect(Collectors.toList());
        this.additionalContainers = TestContainersConfiguration.ADDITIONAL_CONTAINERS.stream().map(additionalContainer -> this.createAdditionalContainer(additionalContainer.getName(), additionalContainer.getPort(), additionalContainer.getDebugPort(), additionalContainer.getImageTag(), additionalContainer.getAdditionalContainerLoggingEnabled())).collect(Collectors.toList());
    }

    private void startContainers() {
        try {
            if (TestContainersConfiguration.POSTGRES_ENABLED) {
                this.postgresContainer.start();
            }
            if (TestContainersConfiguration.KAFKA_ENABLED) {
                if (TestContainersConfiguration.KAFKA_BROKER_COUNT > 1) {
                    this.zookeeperContainer.start();
                }
                this.kafkaContainers.stream().forEach(container -> container.start());
                this.createTopics();
            }
            if (TestContainersConfiguration.DEBEZIUM_ENABLED) {
                this.debeziumContainer.start();
            }
            if (TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_ENABLED) {
                this.kafkaSchemaRegistryContainer.start();
            }
            if (TestContainersConfiguration.KAFKA_CONTROL_CENTER_ENABLED) {
                this.controlCenterContainer.start();
            }
            if (TestContainersConfiguration.CONDUKTOR_ENABLED) {
                this.conduktorContainer.start();
            }
            if (TestContainersConfiguration.WIREMOCK_ENABLED) {
                this.wiremockContainer.start();
            }
            if (TestContainersConfiguration.LOCALSTACK_ENABLED) {
                this.localstackContainer.start();
            }
            this.serviceContainers.stream().forEach(container -> container.start());
            this.additionalContainers.stream().forEach(container -> container.start());
        }
        catch (Exception e) {
            log.error("Component test containers failed to start", (Throwable)e);
            throw e;
        }
    }

    private GenericContainer createServiceContainer(int instance) {
        String containerName = TestContainersConfiguration.SERVICE_NAME + "-" + instance;
        String javaOpts = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:" + TestContainersConfiguration.SERVICE_DEBUG_PORT + " -Xms512m -Xmx512m -Djava.security.egd=file:/dev/./urandom -Dspring.config.additional-location=file:/application.yml";
        GenericContainer container = new GenericContainer(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "/" + TestContainersConfiguration.SERVICE_NAME + ":" + TestContainersConfiguration.SERVICE_IMAGE_TAG).withEnv("JAVA_OPTS", javaOpts).withLabel("dev.lydtech.main-container-label", TestContainersConfiguration.CONTAINER_MAIN_LABEL).withFileSystemBind("./target/test-classes/application-component-test.yml", "/application.yml", BindMode.READ_ONLY).withExposedPorts(new Integer[]{TestContainersConfiguration.SERVICE_PORT, TestContainersConfiguration.SERVICE_DEBUG_PORT}).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).waitingFor(Wait.forHttp((String)"/actuator/health").forPort(TestContainersConfiguration.SERVICE_PORT).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(TestContainersConfiguration.SERVICE_STARTUP_TIMEOUT_SECONDS)));
        if (TestContainersConfiguration.SERVICE_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createAdditionalContainer(String name, Integer port, Integer debugPort, String imageTag, boolean containerLoggingEnabled) {
        String javaOpts = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:" + debugPort + " -Xms512m -Xmx512m -Djava.security.egd=file:/dev/./urandom -Dspring.config.additional-location=file:/application.yml";
        GenericContainer container = new GenericContainer(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "/" + name + ":" + imageTag).withEnv("JAVA_OPTS", javaOpts).withFileSystemBind("./target/test-classes/" + name + "/application-component-test.yml", "/application.yml", BindMode.READ_ONLY).withExposedPorts(new Integer[]{port, debugPort}).withNetwork(this.network).withNetworkAliases(new String[]{name}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + name)).waitingFor(Wait.forHttp((String)"/actuator/health").forPort(port.intValue()).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(TestContainersConfiguration.SERVICE_STARTUP_TIMEOUT_SECONDS)));
        if (containerLoggingEnabled) {
            container.withLogConsumer((Consumer)this.getLogConsumer(name));
        }
        return container;
    }

    private GenericContainer createPostgresContainer() {
        String containerName = Resource.POSTGRES.toString();
        GenericContainer container = ((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"debezium/postgres").asCompatibleSubstituteFor("postgres").withTag(TestContainersConfiguration.POSTGRES_IMAGE_TAG)).withDatabaseName(TestContainersConfiguration.POSTGRES_DATABASE_NAME).withUsername(TestContainersConfiguration.POSTGRES_USERNAME).withPassword(TestContainersConfiguration.POSTGRES_PASSWORD).withNetwork(this.network)).withNetworkAliases(new String[]{TestContainersConfiguration.POSTGRES_HOST_NAME})).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName))).withExposedPorts(new Integer[]{TestContainersConfiguration.POSTGRES_PORT});
        if (TestContainersConfiguration.POSTGRES_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private KafkaContainer createKafkaContainer(int instance) {
        String containerName = instance == 1 ? Resource.KAFKA.toString() : Resource.KAFKA.toString() + "-" + instance;
        KafkaContainer container = (KafkaContainer)((KafkaContainer)((KafkaContainer)new KafkaContainer(DockerImageName.parse((String)"confluentinc/cp-kafka").withTag(TestContainersConfiguration.KAFKA_CONFLUENT_IMAGE_TAG)).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        container = this.configureCommonKafkaContainerEnv(container, instance);
        if (TestContainersConfiguration.KAFKA_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private KafkaContainer createKafkaServerContainer(int instance) {
        String containerName = instance == 1 ? Resource.KAFKA.toString() : Resource.KAFKA.toString() + "-" + instance;
        DockerImageName cpServerImage = DockerImageName.parse((String)"confluentinc/cp-server").asCompatibleSubstituteFor("confluentinc/cp-kafka");
        KafkaContainer container = (KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)new KafkaContainer(cpServerImage.withTag(TestContainersConfiguration.KAFKA_CONFLUENT_IMAGE_TAG)).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withEnv("KAFKA_CONFLUENT_LICENSE_TOPIC_REPLICATION_FACTOR", "1")).withEnv("KAFKA_CONFLUENT_BALANCER_TOPIC_REPLICATION_FACTOR", "1")).withEnv("KAFKA_JMX_PORT", TestContainersConfiguration.KAFKA_CONTROL_CENTER_JMX_PORT)).withEnv("KAFKA_JMX_HOSTNAME", "localhost")).withEnv("CONFLUENT_METRICS_REPORTER_BOOTSTRAP_SERVERS", containerName + ":9092")).withEnv("CONFLUENT_METRICS_REPORTER_TOPIC_REPLICAS", "1")).withEnv("KAFKA_METRIC_REPORTERS", "io.confluent.metrics.reporter.ConfluentMetricsReporter")).withEnv("CONFLUENT_METRICS_ENABLE", "true")).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        container.withEnv("KAFKA_METRIC_REPORTERS", "io.confluent.metrics.reporter.ConfluentMetricsReporter");
        container = this.configureCommonKafkaContainerEnv(container, instance);
        if (TestContainersConfiguration.KAFKA_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private KafkaContainer configureCommonKafkaContainerEnv(KafkaContainer kafkaContainer, int instance) {
        if (TestContainersConfiguration.KAFKA_BROKER_COUNT > 1) {
            kafkaContainer.withExternalZookeeper("zookeeper:2181");
        }
        return (KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)kafkaContainer.withEnv("KAFKA_BROKER_ID", String.valueOf(instance))).withEnv("KAFKA_NUM_PARTITIONS", String.valueOf(TestContainersConfiguration.KAFKA_TOPIC_PARTITION_COUNT))).withEnv("KAFKA_DEFAULT_REPLICATION_FACTOR", String.valueOf(TestContainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR))).withEnv("KAFKA_MIN_INSYNC_REPLICAS", String.valueOf(TestContainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS))).withEnv("KAFKA_OFFSETS_TOPIC_REPLICATION_FACTOR", String.valueOf(TestContainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR))).withEnv("KAFKA_GROUP_INITIAL_REBALANCE_DELAY_MS", "0")).withEnv("KAFKA_TRANSACTION_STATE_LOG_MIN_ISR", String.valueOf(TestContainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS))).withEnv("KAFKA_TRANSACTION_STATE_LOG_REPLICATION_FACTOR", String.valueOf(TestContainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR));
    }

    private GenericContainer createZookeeperContainer() {
        return new GenericContainer("confluentinc/cp-zookeeper:4.0.0").withNetwork(this.network).withNetworkAliases(new String[]{"zookeeper"}).withEnv("ZOOKEEPER_CLIENT_PORT", "2181").withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-zookeeper"));
    }

    private DebeziumContainer createDebeziumContainer() {
        String containerName = Resource.DEBEZIUM.toString();
        DebeziumContainer container = (DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)new DebeziumContainer(DockerImageName.parse((String)"debezium/connect").withTag(TestContainersConfiguration.DEBEZIUM_IMAGE_TAG)).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withKafka(this.kafkaContainers.get(0)).withExposedPorts(new Integer[]{TestContainersConfiguration.DEBEZIUM_PORT})).dependsOn(new Startable[]{(Startable)this.kafkaContainers.get(0)})).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        if (TestContainersConfiguration.DEBEZIUM_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createKafkaSchemaRegistryContainer() {
        String containerName = Resource.KAFKA_SCHEMA_REGISTRY.toString().replace("_", "-");
        GenericContainer container = new GenericContainer("confluentinc/cp-schema-registry:" + TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_CONFLUENT_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).withExposedPorts(new Integer[]{TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_PORT}).withEnv("SCHEMA_REGISTRY_HOST_NAME", containerName).withEnv("SCHEMA_REGISTRY_KAFKASTORE_BOOTSTRAP_SERVERS", Resource.KAFKA.toString() + ":9092").withEnv("SCHEMA_REGISTRY_LISTENERS", "http://0.0.0.0:" + TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_PORT).dependsOn(new Startable[]{(Startable)this.kafkaContainers.get(0)});
        if (TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createControlCenterContainer() {
        String containerName = Resource.KAFKA_CONTROL_CENTER.toString().replace("_", "-");
        Consumer<CreateContainerCmd> cmd = e -> e.withHostConfig(e.getHostConfig().withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindPort((int)TestContainersConfiguration.KAFKA_CONTROL_CENTER_PORT), new ExposedPort(TestContainersConfiguration.KAFKA_CONTROL_CENTER_PORT))})).withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName);
        GenericContainer container = new GenericContainer("confluentinc/cp-enterprise-control-center:" + TestContainersConfiguration.KAFKA_CONTROL_CENTER_CONFLUENT_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd).withEnv("CONTROL_CENTER_BOOTSTRAP_SERVERS", Resource.KAFKA.toString() + ":9092").withEnv("CONTROL_CENTER_REPLICATION_FACTOR", "1").withEnv("CONTROL_CENTER_INTERNAL_TOPICS_PARTITIONS", String.valueOf(TestContainersConfiguration.KAFKA_TOPIC_PARTITION_COUNT)).withEnv("CONTROL_CENTER_MONITORING_INTERCEPTOR_TOPIC_PARTITIONS", String.valueOf(TestContainersConfiguration.KAFKA_TOPIC_PARTITION_COUNT)).withEnv("CONFLUENT_METRICS_TOPIC_REPLICATION", "1").withEnv("PORT", String.valueOf(TestContainersConfiguration.KAFKA_CONTROL_CENTER_PORT)).withEnv("CONTROL_CENTER_REST_LISTENERS", "http://0.0.0.0:" + TestContainersConfiguration.KAFKA_CONTROL_CENTER_PORT).withExposedPorts(new Integer[]{TestContainersConfiguration.KAFKA_CONTROL_CENTER_PORT}).withStartupTimeout(Duration.ofMinutes(3L));
        if (TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_ENABLED) {
            container.withEnv("CONTROL_CENTER_SCHEMA_REGISTRY_URL", "http://" + Resource.KAFKA_SCHEMA_REGISTRY.toString().replace("_", "-") + ":" + TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_PORT);
        }
        if (TestContainersConfiguration.KAFKA_CONTROL_CENTER_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createConduktorContainer() {
        String containerName = Resource.CONDUKTOR.toString();
        int containerExposedPort = 8080;
        Consumer<CreateContainerCmd> cmd = e -> e.withHostConfig(e.getHostConfig().withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindPort((int)TestContainersConfiguration.CONDUKTOR_PORT), new ExposedPort(containerExposedPort))})).withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName);
        GenericContainer container = new GenericContainer("conduktor/conduktor-platform:" + TestContainersConfiguration.CONDUKTOR_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd).withEnv("CDK_ORGANIZATION_NAME", "component-test-framework").withEnv("CDK_ADMIN_EMAIL", "admin@conduktor.io").withEnv("CDK_ADMIN_PASSWORD", "admin").withEnv("CDK_CLUSTERS_0_ID", "CTF").withEnv("CDK_CLUSTERS_0_NAME", "Local Cluster").withEnv("CDK_CLUSTERS_0_BOOTSTRAPSERVERS", Resource.KAFKA.toString() + ":9092").withExposedPorts(new Integer[]{containerExposedPort});
        if (TestContainersConfiguration.CONDUKTOR_LICENSE_KEY != null) {
            container.withEnv("LICENSE_KEY", TestContainersConfiguration.CONDUKTOR_LICENSE_KEY);
        }
        if (TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_ENABLED) {
            container.withEnv("SCHEMA_REGISTRY_URL", "http://" + Resource.KAFKA_SCHEMA_REGISTRY.toString().replace("_", "-") + ":" + TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_PORT);
        }
        if (TestContainersConfiguration.CONDUKTOR_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createWiremockContainer() {
        String containerName = Resource.WIREMOCK.toString();
        GenericContainer container = new GenericContainer("wiremock/wiremock:" + TestContainersConfiguration.WIREMOCK_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).withClasspathResourceMapping("/wiremock", "/home/wiremock/mappings", BindMode.READ_WRITE).withExposedPorts(new Integer[]{TestContainersConfiguration.WIREMOCK_PORT}).waitingFor((WaitStrategy)Wait.forHttp((String)"/health").forStatusCode(204));
        if (TestContainersConfiguration.WIREMOCK_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createLocalstackContainer() {
        String containerName = Resource.LOCALSTACK.toString();
        GenericContainer container = new GenericContainer("localstack/localstack:" + TestContainersConfiguration.LOCALSTACK_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).withEnv("SERVICES", TestContainersConfiguration.LOCALSTACK_SERVICES).withExposedPorts(new Integer[]{TestContainersConfiguration.LOCALSTACK_PORT});
        if (TestContainersConfiguration.LOCALSTACK_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private void createTopics() {
        if (!TestContainersConfiguration.KAFKA_TOPICS.isEmpty()) {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", this.kafkaContainers.get(0).getBootstrapServers());
            Admin admin = Admin.create((Properties)properties);
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>(TestContainersConfiguration.KAFKA_TOPICS.size());
            int partitions = TestContainersConfiguration.KAFKA_TOPIC_PARTITION_COUNT;
            short replicationFactor = 1;
            for (String topicName : TestContainersConfiguration.KAFKA_TOPICS) {
                NewTopic newTopic = new NewTopic(topicName, partitions, replicationFactor);
                newTopics.add(newTopic);
            }
            CreateTopicsResult result = admin.createTopics(newTopics);
            try {
                result.all().get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Topic creation failed.", (Throwable)e);
                throw new RuntimeException("Topic creation failed: " + e.getMessage(), e);
            }
            log.info("Created topics: " + TestContainersConfiguration.KAFKA_TOPICS);
        }
    }

    private Slf4jLogConsumer getLogConsumer(String containerName) {
        return (Slf4jLogConsumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)("container." + containerName))).withRemoveAnsiCodes(false);
    }
}

