/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.management;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import dev.lydtech.component.framework.configuration.TestcontainersConfiguration;
import dev.lydtech.component.framework.resource.Resource;
import io.debezium.testing.testcontainers.DebeziumContainer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public final class TestcontainersManager {
    private static final Logger log = LoggerFactory.getLogger(TestcontainersManager.class);
    private Network network;
    private List<GenericContainer> serviceContainers = new ArrayList<GenericContainer>(1);
    private List<GenericContainer> additionalContainers;
    private GenericContainer postgresContainer;
    private MongoDBContainer mongoDbContainer;
    private List<KafkaContainer> kafkaContainers;
    private GenericContainer zookeeperContainer;
    private DebeziumContainer debeziumContainer;
    private GenericContainer kafkaSchemaRegistryContainer;
    private GenericContainer wiremockContainer;
    private GenericContainer localstackContainer;
    private GenericContainer controlCenterContainer;
    private GenericContainer conduktorContainer;
    private GenericContainer conduktorGatewayContainer;
    private GenericContainer elasticSearchContainer;

    private TestcontainersManager() {
    }

    public static void initialise() {
        TestcontainersManager manager = new TestcontainersManager();
        log.info("Creating testcontainers...");
        manager.createContainers();
        log.info("Starting testcontainers...");
        manager.startContainers();
        log.info("Started testcontainers.");
    }

    private void createContainers() {
        if (TestcontainersConfiguration.SERVICE_INSTANCE_COUNT < 1) {
            throw new RuntimeException("At least one service container should be started");
        }
        this.network = Network.newNetwork();
        if (TestcontainersConfiguration.POSTGRES_ENABLED) {
            this.postgresContainer = this.createPostgresContainer();
        }
        if (TestcontainersConfiguration.MONGODB_ENABLED) {
            this.mongoDbContainer = this.createMongoDBContainer();
        }
        if (TestcontainersConfiguration.KAFKA_ENABLED) {
            if (TestcontainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR > TestcontainersConfiguration.KAFKA_BROKER_COUNT) {
                throw new RuntimeException("kafka.topic.replication.factor: " + TestcontainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR + " - must not be greater than kafka.broker.count: " + TestcontainersConfiguration.KAFKA_BROKER_COUNT);
            }
            if (TestcontainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS > TestcontainersConfiguration.KAFKA_BROKER_COUNT) {
                throw new RuntimeException("kafka.min.insync.replicas: " + TestcontainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS + " - must not be greater than kafka.broker.count: " + TestcontainersConfiguration.KAFKA_BROKER_COUNT);
            }
            if (TestcontainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS > TestcontainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR) {
                throw new RuntimeException("kafka.min.insync.replicas: " + TestcontainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS + " - must not be greater than kafka.topic.replication.factor: " + TestcontainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR);
            }
            if (TestcontainersConfiguration.KAFKA_BROKER_COUNT > 1) {
                this.zookeeperContainer = this.createZookeeperContainer();
            }
            this.kafkaContainers = TestcontainersConfiguration.KAFKA_CONTROL_CENTER_ENABLED && TestcontainersConfiguration.KAFKA_CONTROL_CENTER_EXPORT_METRICS_ENABLED ? IntStream.range(1, TestcontainersConfiguration.KAFKA_BROKER_COUNT + 1).mapToObj(this::createKafkaServerContainer).collect(Collectors.toList()) : IntStream.range(1, TestcontainersConfiguration.KAFKA_BROKER_COUNT + 1).mapToObj(this::createKafkaContainer).collect(Collectors.toList());
        }
        if (TestcontainersConfiguration.DEBEZIUM_ENABLED) {
            if (!TestcontainersConfiguration.KAFKA_ENABLED) {
                throw new RuntimeException("Kafka must be enabled in order to use Debezium.");
            }
            this.debeziumContainer = this.createDebeziumContainer();
        }
        if (TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_ENABLED) {
            if (!TestcontainersConfiguration.KAFKA_ENABLED) {
                throw new RuntimeException("Kafka must be enabled in order to use Kafka schema registry.");
            }
            this.kafkaSchemaRegistryContainer = this.createKafkaSchemaRegistryContainer();
        }
        if (TestcontainersConfiguration.WIREMOCK_ENABLED) {
            this.wiremockContainer = this.createWiremockContainer();
        }
        if (TestcontainersConfiguration.LOCALSTACK_ENABLED) {
            this.localstackContainer = this.createLocalstackContainer();
        }
        if (TestcontainersConfiguration.KAFKA_CONTROL_CENTER_ENABLED) {
            if (!TestcontainersConfiguration.KAFKA_ENABLED) {
                throw new RuntimeException("Kafka must be enabled in order to use Control Center.");
            }
            this.controlCenterContainer = this.createControlCenterContainer();
        }
        if (TestcontainersConfiguration.CONDUKTOR_ENABLED) {
            if (!TestcontainersConfiguration.KAFKA_ENABLED) {
                throw new RuntimeException("Kafka must be enabled in order to use Conduktor.");
            }
            this.conduktorContainer = this.createConduktorContainer();
        }
        if (TestcontainersConfiguration.CONDUKTOR_GATEWAY_ENABLED) {
            if (!TestcontainersConfiguration.KAFKA_ENABLED) {
                throw new RuntimeException("Kafka must be enabled in order to use Conduktor Gateway.");
            }
            this.conduktorGatewayContainer = this.createConduktorGatewayContainer();
        }
        if (TestcontainersConfiguration.ELASTICSEARCH_ENABLED) {
            this.elasticSearchContainer = this.createElasticsearchContainer();
        }
        this.serviceContainers = IntStream.range(1, TestcontainersConfiguration.SERVICE_INSTANCE_COUNT + 1).mapToObj(this::createServiceContainer).collect(Collectors.toList());
        this.additionalContainers = TestcontainersConfiguration.ADDITIONAL_CONTAINERS.stream().map(additionalContainer -> this.createAdditionalContainer(additionalContainer.getName(), additionalContainer.getPort(), additionalContainer.getDebugPort(), additionalContainer.getImageTag(), additionalContainer.getAdditionalContainerLoggingEnabled())).collect(Collectors.toList());
    }

    private void startContainers() {
        try {
            if (TestcontainersConfiguration.POSTGRES_ENABLED) {
                this.postgresContainer.start();
            }
            if (TestcontainersConfiguration.MONGODB_ENABLED) {
                this.mongoDbContainer.start();
            }
            if (TestcontainersConfiguration.KAFKA_ENABLED) {
                if (TestcontainersConfiguration.KAFKA_BROKER_COUNT > 1) {
                    this.zookeeperContainer.start();
                }
                this.kafkaContainers.stream().forEach(container -> container.start());
                this.createTopics();
            }
            if (TestcontainersConfiguration.DEBEZIUM_ENABLED) {
                this.debeziumContainer.start();
            }
            if (TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_ENABLED) {
                this.kafkaSchemaRegistryContainer.start();
            }
            if (TestcontainersConfiguration.KAFKA_CONTROL_CENTER_ENABLED) {
                this.controlCenterContainer.start();
            }
            if (TestcontainersConfiguration.CONDUKTOR_ENABLED) {
                this.conduktorContainer.start();
            }
            if (TestcontainersConfiguration.CONDUKTOR_GATEWAY_ENABLED) {
                this.conduktorGatewayContainer.start();
            }
            if (TestcontainersConfiguration.WIREMOCK_ENABLED) {
                this.wiremockContainer.start();
            }
            if (TestcontainersConfiguration.LOCALSTACK_ENABLED) {
                this.localstackContainer.start();
            }
            if (TestcontainersConfiguration.ELASTICSEARCH_ENABLED) {
                this.elasticSearchContainer.start();
            }
            this.serviceContainers.stream().forEach(container -> container.start());
            this.additionalContainers.stream().forEach(container -> container.start());
        }
        catch (Exception e) {
            log.error("Component test containers failed to start", (Throwable)e);
            throw e;
        }
    }

    private GenericContainer createServiceContainer(int instance) {
        String containerName = TestcontainersConfiguration.SERVICE_NAME + "-" + instance;
        String suspendFlag = TestcontainersConfiguration.SERVICE_DEBUG_SUSPEND ? "y" : "n";
        String javaOpts = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspendFlag + ",address=*:" + TestcontainersConfiguration.SERVICE_DEBUG_PORT + " -Xms512m -Xmx512m -Djava.security.egd=file:/dev/./urandom -D" + TestcontainersConfiguration.SERVICE_CONFIG_FILES_SYSTEM_PROPERTY + "=file:/application.yml";
        TestcontainersConfiguration.SERVICE_ENV_VARS.put("JAVA_OPTS", javaOpts);
        GenericContainer container = new GenericContainer(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "/" + TestcontainersConfiguration.SERVICE_NAME + ":" + TestcontainersConfiguration.SERVICE_IMAGE_TAG).withEnv(TestcontainersConfiguration.SERVICE_ENV_VARS).withLabel("dev.lydtech.main-container-label", TestcontainersConfiguration.CONTAINER_MAIN_LABEL).withFileSystemBind(TestcontainersConfiguration.SERVICE_APPLICATION_YML_PATH, "/application.yml", BindMode.READ_ONLY).withExposedPorts(new Integer[]{TestcontainersConfiguration.SERVICE_PORT, TestcontainersConfiguration.SERVICE_DEBUG_PORT}).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        TestcontainersConfiguration.SERVICE_ADDITIONAL_FILESYSTEM_BINDS.keySet().forEach(source -> container.withFileSystemBind(source, TestcontainersConfiguration.SERVICE_ADDITIONAL_FILESYSTEM_BINDS.get(source), BindMode.READ_ONLY));
        container.withReuse(true);
        if (TestcontainersConfiguration.SERVICE_STARTUP_LOG_MESSAGE != null) {
            container.waitingFor((WaitStrategy)Wait.forLogMessage((String)TestcontainersConfiguration.SERVICE_STARTUP_LOG_MESSAGE, (int)1)).withStartupTimeout(Duration.ofSeconds(TestcontainersConfiguration.SERVICE_STARTUP_TIMEOUT_SECONDS));
        } else {
            container.waitingFor(Wait.forHttp((String)TestcontainersConfiguration.SERVICE_STARTUP_HEALTH_ENDPOINT).forPort(TestcontainersConfiguration.SERVICE_PORT).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(TestcontainersConfiguration.SERVICE_STARTUP_TIMEOUT_SECONDS)));
        }
        if (TestcontainersConfiguration.SERVICE_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createAdditionalContainer(String name, Integer port, Integer debugPort, String imageTag, boolean containerLoggingEnabled) {
        String javaOpts = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:" + debugPort + " -Xms512m -Xmx512m -Djava.security.egd=file:/dev/./urandom -Dspring.config.additional-location=file:/application.yml";
        GenericContainer container = new GenericContainer(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "/" + name + ":" + imageTag).withEnv("JAVA_OPTS", javaOpts).withFileSystemBind("./target/test-classes/" + name + "/application-component-test.yml", "/application.yml", BindMode.READ_ONLY).withExposedPorts(new Integer[]{port, debugPort}).withNetwork(this.network).withNetworkAliases(new String[]{name}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + name)).withReuse(true).waitingFor(Wait.forHttp((String)"/actuator/health").forPort(port.intValue()).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(TestcontainersConfiguration.SERVICE_STARTUP_TIMEOUT_SECONDS)));
        if (containerLoggingEnabled) {
            container.withLogConsumer((Consumer)this.getLogConsumer(name));
        }
        return container;
    }

    private GenericContainer createPostgresContainer() {
        String containerName = Resource.POSTGRES.toString();
        GenericContainer container = ((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"debezium/postgres").asCompatibleSubstituteFor("postgres").withTag(TestcontainersConfiguration.POSTGRES_IMAGE_TAG)).withDatabaseName(TestcontainersConfiguration.POSTGRES_DATABASE_NAME).withUsername(TestcontainersConfiguration.POSTGRES_USERNAME).withPassword(TestcontainersConfiguration.POSTGRES_PASSWORD).withNetwork(this.network)).withNetworkAliases(new String[]{TestcontainersConfiguration.POSTGRES_HOST_NAME})).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName))).withReuse(true)).withExposedPorts(new Integer[]{TestcontainersConfiguration.POSTGRES_PORT});
        if (TestcontainersConfiguration.POSTGRES_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private MongoDBContainer createMongoDBContainer() {
        String containerName = Resource.MONGODB.toString();
        MongoDBContainer container = (MongoDBContainer)((MongoDBContainer)((MongoDBContainer)((MongoDBContainer)new MongoDBContainer("mongo:" + TestcontainersConfiguration.MONGODB_IMAGE_TAG).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withReuse(true)).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        if (TestcontainersConfiguration.MONGODB_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private KafkaContainer createKafkaContainer(int instance) {
        String containerName = instance == 1 ? Resource.KAFKA.toString() : Resource.KAFKA.toString() + "-" + instance;
        KafkaContainer container = (KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)new KafkaContainer(DockerImageName.parse((String)"confluentinc/cp-kafka").withTag(TestcontainersConfiguration.KAFKA_CONFLUENT_IMAGE_TAG)).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withReuse(true)).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        container = this.configureCommonKafkaContainerEnv(container, instance);
        if (TestcontainersConfiguration.KAFKA_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private KafkaContainer createKafkaServerContainer(int instance) {
        String containerName = instance == 1 ? Resource.KAFKA.toString() : Resource.KAFKA.toString() + "-" + instance;
        DockerImageName cpServerImage = DockerImageName.parse((String)"confluentinc/cp-server").asCompatibleSubstituteFor("confluentinc/cp-kafka");
        KafkaContainer container = (KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)new KafkaContainer(cpServerImage.withTag(TestcontainersConfiguration.KAFKA_CONFLUENT_IMAGE_TAG)).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withEnv("KAFKA_CONFLUENT_LICENSE_TOPIC_REPLICATION_FACTOR", "1")).withEnv("KAFKA_CONFLUENT_BALANCER_TOPIC_REPLICATION_FACTOR", "1")).withEnv("KAFKA_JMX_PORT", TestcontainersConfiguration.KAFKA_CONTROL_CENTER_JMX_PORT)).withEnv("KAFKA_JMX_HOSTNAME", "localhost")).withEnv("CONFLUENT_METRICS_REPORTER_BOOTSTRAP_SERVERS", containerName + ":9092")).withEnv("CONFLUENT_METRICS_REPORTER_TOPIC_REPLICAS", "1")).withEnv("KAFKA_METRIC_REPORTERS", "io.confluent.metrics.reporter.ConfluentMetricsReporter")).withEnv("CONFLUENT_METRICS_ENABLE", "true")).withReuse(true)).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        container.withEnv("KAFKA_METRIC_REPORTERS", "io.confluent.metrics.reporter.ConfluentMetricsReporter");
        container = this.configureCommonKafkaContainerEnv(container, instance);
        if (TestcontainersConfiguration.KAFKA_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private KafkaContainer configureCommonKafkaContainerEnv(KafkaContainer kafkaContainer, int instance) {
        if (TestcontainersConfiguration.KAFKA_BROKER_COUNT > 1) {
            kafkaContainer.withExternalZookeeper("zookeeper:2181");
        }
        if (TestcontainersConfiguration.KAFKA_SASL_PLAIN_ENABLED) {
            if (TestcontainersConfiguration.KAFKA_SASL_PLAIN_USERNAME == null || TestcontainersConfiguration.KAFKA_SASL_PLAIN_USERNAME.isBlank() || TestcontainersConfiguration.KAFKA_SASL_PLAIN_PASSWORD == null || TestcontainersConfiguration.KAFKA_SASL_PLAIN_PASSWORD.isBlank()) {
                throw new RuntimeException("kafka.sasl.plain.enabled is true so kafka.sasl.plain.username: " + TestcontainersConfiguration.KAFKA_SASL_PLAIN_USERNAME + " - and kafka.sasl.plain.password: " + TestcontainersConfiguration.KAFKA_SASL_PLAIN_PASSWORD + " - must both be set.");
            }
            String jaasConfig = String.format("%s required username=\"%s\" password=\"%s\" user_%s=\"%s\";", PlainLoginModule.class.getName(), TestcontainersConfiguration.KAFKA_SASL_PLAIN_USERNAME, TestcontainersConfiguration.KAFKA_SASL_PLAIN_PASSWORD, TestcontainersConfiguration.KAFKA_SASL_PLAIN_USERNAME, TestcontainersConfiguration.KAFKA_SASL_PLAIN_PASSWORD);
            kafkaContainer.withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", "PLAINTEXT:SASL_PLAINTEXT,BROKER:SASL_PLAINTEXT");
            kafkaContainer.withEnv("KAFKA_SASL_MECHANISM_INTER_BROKER_PROTOCOL", "PLAIN");
            kafkaContainer.withEnv("KAFKA_LISTENER_NAME_BROKER_SASL_ENABLED_MECHANISMS", "PLAIN");
            kafkaContainer.withEnv("KAFKA_LISTENER_NAME_BROKER_PLAIN_SASL_JAAS_CONFIG", jaasConfig);
            kafkaContainer.withEnv("KAFKA_LISTENER_NAME_PLAINTEXT_SASL_ENABLED_MECHANISMS", "PLAIN");
            kafkaContainer.withEnv("KAFKA_LISTENER_NAME_PLAINTEXT_PLAIN_SASL_JAAS_CONFIG", jaasConfig);
        }
        return (KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)kafkaContainer.withEnv("KAFKA_BROKER_ID", String.valueOf(instance))).withEnv("KAFKA_NUM_PARTITIONS", String.valueOf(TestcontainersConfiguration.KAFKA_TOPIC_PARTITION_COUNT))).withEnv("KAFKA_DEFAULT_REPLICATION_FACTOR", String.valueOf(TestcontainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR))).withEnv("KAFKA_MIN_INSYNC_REPLICAS", String.valueOf(TestcontainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS))).withEnv("KAFKA_OFFSETS_TOPIC_REPLICATION_FACTOR", String.valueOf(TestcontainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR))).withEnv("KAFKA_GROUP_INITIAL_REBALANCE_DELAY_MS", "0")).withEnv("KAFKA_TRANSACTION_STATE_LOG_MIN_ISR", String.valueOf(TestcontainersConfiguration.KAFKA_MIN_INSYNC_REPLICAS))).withEnv("KAFKA_TRANSACTION_STATE_LOG_REPLICATION_FACTOR", String.valueOf(TestcontainersConfiguration.KAFKA_TOPIC_REPLICATION_FACTOR));
    }

    private GenericContainer createZookeeperContainer() {
        return new GenericContainer("confluentinc/cp-zookeeper:4.0.0").withNetwork(this.network).withNetworkAliases(new String[]{"zookeeper"}).withEnv("ZOOKEEPER_CLIENT_PORT", "2181").withReuse(true).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-zookeeper"));
    }

    private DebeziumContainer createDebeziumContainer() {
        String containerName = Resource.DEBEZIUM.toString();
        DebeziumContainer container = (DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)new DebeziumContainer(DockerImageName.parse((String)"debezium/connect").withTag(TestcontainersConfiguration.DEBEZIUM_IMAGE_TAG)).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withKafka(this.kafkaContainers.get(0)).withExposedPorts(new Integer[]{TestcontainersConfiguration.DEBEZIUM_PORT})).dependsOn(new Startable[]{(Startable)this.kafkaContainers.get(0)})).withReuse(true)).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        if (TestcontainersConfiguration.DEBEZIUM_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createKafkaSchemaRegistryContainer() {
        String containerName = Resource.KAFKA_SCHEMA_REGISTRY.toString().replace("_", "-");
        GenericContainer container = new GenericContainer("confluentinc/cp-schema-registry:" + TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_CONFLUENT_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).withExposedPorts(new Integer[]{TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_PORT}).withEnv("SCHEMA_REGISTRY_HOST_NAME", containerName).withEnv("SCHEMA_REGISTRY_KAFKASTORE_BOOTSTRAP_SERVERS", Resource.KAFKA.toString() + ":9092").withEnv("SCHEMA_REGISTRY_LISTENERS", "http://0.0.0.0:" + TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_PORT).withReuse(true).dependsOn(new Startable[]{(Startable)this.kafkaContainers.get(0)});
        if (TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createControlCenterContainer() {
        String containerName = Resource.KAFKA_CONTROL_CENTER.toString().replace("_", "-");
        Consumer<CreateContainerCmd> cmd = e -> e.withHostConfig(e.getHostConfig().withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindPort((int)TestcontainersConfiguration.KAFKA_CONTROL_CENTER_PORT), new ExposedPort(TestcontainersConfiguration.KAFKA_CONTROL_CENTER_PORT))})).withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName);
        GenericContainer container = new GenericContainer("confluentinc/cp-enterprise-control-center:" + TestcontainersConfiguration.KAFKA_CONTROL_CENTER_CONFLUENT_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd).withEnv("CONTROL_CENTER_BOOTSTRAP_SERVERS", Resource.KAFKA.toString() + ":9092").withEnv("CONTROL_CENTER_REPLICATION_FACTOR", "1").withEnv("CONTROL_CENTER_INTERNAL_TOPICS_PARTITIONS", String.valueOf(TestcontainersConfiguration.KAFKA_TOPIC_PARTITION_COUNT)).withEnv("CONTROL_CENTER_MONITORING_INTERCEPTOR_TOPIC_PARTITIONS", String.valueOf(TestcontainersConfiguration.KAFKA_TOPIC_PARTITION_COUNT)).withEnv("CONFLUENT_METRICS_TOPIC_REPLICATION", "1").withEnv("PORT", String.valueOf(TestcontainersConfiguration.KAFKA_CONTROL_CENTER_PORT)).withEnv("CONTROL_CENTER_REST_LISTENERS", "http://0.0.0.0:" + TestcontainersConfiguration.KAFKA_CONTROL_CENTER_PORT).withExposedPorts(new Integer[]{TestcontainersConfiguration.KAFKA_CONTROL_CENTER_PORT}).withReuse(true).withStartupTimeout(Duration.ofMinutes(3L));
        if (TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_ENABLED) {
            container.withEnv("CONTROL_CENTER_SCHEMA_REGISTRY_URL", "http://" + Resource.KAFKA_SCHEMA_REGISTRY.toString().replace("_", "-") + ":" + TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_PORT);
        }
        if (TestcontainersConfiguration.KAFKA_CONTROL_CENTER_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createConduktorContainer() {
        String containerName = Resource.CONDUKTOR.toString();
        int containerExposedPort = 8080;
        Consumer<CreateContainerCmd> cmd = e -> e.withHostConfig(e.getHostConfig().withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindPort((int)TestcontainersConfiguration.CONDUKTOR_PORT), new ExposedPort(containerExposedPort))})).withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName);
        GenericContainer container = new GenericContainer("conduktor/conduktor-platform:" + TestcontainersConfiguration.CONDUKTOR_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd).withEnv("CDK_ORGANIZATION_NAME", "component-test-framework").withEnv("CDK_ADMIN_EMAIL", "admin@conduktor.io").withEnv("CDK_ADMIN_PASSWORD", "admin").withEnv("CDK_CLUSTERS_0_ID", "CTF").withEnv("CDK_CLUSTERS_0_NAME", "Local Cluster").withEnv("CDK_CLUSTERS_0_BOOTSTRAPSERVERS", Resource.KAFKA.toString() + ":9092").withReuse(true).withExposedPorts(new Integer[]{containerExposedPort});
        if (TestcontainersConfiguration.CONDUKTOR_LICENSE_KEY != null) {
            container.withEnv("LICENSE_KEY", TestcontainersConfiguration.CONDUKTOR_LICENSE_KEY);
        }
        if (TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_ENABLED) {
            container.withEnv("SCHEMA_REGISTRY_URL", "http://" + Resource.KAFKA_SCHEMA_REGISTRY.toString().replace("_", "-") + ":" + TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_PORT);
        }
        if (TestcontainersConfiguration.CONDUKTOR_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createConduktorGatewayContainer() {
        String containerName = Resource.CONDUKTORGATEWAY.toString();
        GenericContainer container = new GenericContainer("conduktor/conduktor-gateway:" + TestcontainersConfiguration.CONDUKTOR_GATEWAY_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).withEnv("KAFKA_BOOTSTRAP_SERVERS", Resource.KAFKA.toString() + ":9092").withEnv("GATEWAY_HOST", Resource.CONDUKTORGATEWAY.toString()).withEnv("GATEWAY_PORT_RANGE", TestcontainersConfiguration.CONDUKTOR_GATEWAY_PROXY_PORT + ":" + TestcontainersConfiguration.CONDUKTOR_GATEWAY_PROXY_PORT).withEnv("HTTP_PORT", String.valueOf(TestcontainersConfiguration.CONDUKTOR_GATEWAY_HTTP_PORT)).withEnv("FEATURE_FLAGS_SINGLE_TENANT", "true").withEnv("AUTHENTICATION_AUTHENTICATOR_TYPE", "NONE").withExposedPorts(new Integer[]{TestcontainersConfiguration.CONDUKTOR_GATEWAY_PROXY_PORT, TestcontainersConfiguration.CONDUKTOR_GATEWAY_HTTP_PORT}).withReuse(true).waitingFor((WaitStrategy)Wait.forListeningPort());
        if (TestcontainersConfiguration.CONDUKTOR_GATEWAY_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createWiremockContainer() {
        String containerName = Resource.WIREMOCK.toString();
        GenericContainer container = new GenericContainer("wiremock/wiremock:" + TestcontainersConfiguration.WIREMOCK_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).withClasspathResourceMapping("/wiremock", "/home/wiremock/mappings", BindMode.READ_WRITE).withExposedPorts(new Integer[]{TestcontainersConfiguration.WIREMOCK_PORT}).withReuse(true).waitingFor((WaitStrategy)Wait.forHttp((String)"/health").forStatusCode(204));
        if (TestcontainersConfiguration.WIREMOCK_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createLocalstackContainer() {
        String containerName = Resource.LOCALSTACK.toString();
        GenericContainer container = new GenericContainer("localstack/localstack:" + TestcontainersConfiguration.LOCALSTACK_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).withEnv("SERVICES", TestcontainersConfiguration.LOCALSTACK_SERVICES).withReuse(true).withExposedPorts(new Integer[]{TestcontainersConfiguration.LOCALSTACK_PORT});
        if (TestcontainersConfiguration.LOCALSTACK_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createElasticsearchContainer() {
        String containerName = Resource.ELASTICSEARCH.toString();
        DockerImageName elasticsearchImage = DockerImageName.parse((String)"elastic/elasticsearch").asCompatibleSubstituteFor("docker.elastic.co/elasticsearch/elasticsearch");
        ElasticsearchContainer container = (ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)new ElasticsearchContainer(elasticsearchImage.withTag(TestcontainersConfiguration.ELASTICSEARCH_IMAGE_TAG)).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withEnv("cluster.name", TestcontainersConfiguration.ELASTICSEARCH_CLUSTER_NAME)).withEnv("discovery.type", TestcontainersConfiguration.ELASTICSEARCH_DISCOVERY_TYPE)).withEnv("xpack.security.enabled", "false")).withReuse(true)).withCreateContainerCmdModifier(cmd -> cmd.withName(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        if (TestcontainersConfiguration.ELASTICSEARCH_PASSWORD != null && !TestcontainersConfiguration.ELASTICSEARCH_PASSWORD.isBlank()) {
            container.withPassword(TestcontainersConfiguration.ELASTICSEARCH_PASSWORD);
        }
        if (TestcontainersConfiguration.ELASTICSEARCH_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private void createTopics() {
        if (!TestcontainersConfiguration.KAFKA_TOPICS.isEmpty()) {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", this.kafkaContainers.get(0).getBootstrapServers());
            if (TestcontainersConfiguration.KAFKA_SASL_PLAIN_ENABLED) {
                properties.put("security.protocol", "SASL_PLAINTEXT");
                properties.put("sasl.mechanism", "PLAIN");
                String jaasConfig = String.format("%s required username=\"%s\" password=\"%s\";", PlainLoginModule.class.getName(), TestcontainersConfiguration.KAFKA_SASL_PLAIN_USERNAME, TestcontainersConfiguration.KAFKA_SASL_PLAIN_PASSWORD);
                properties.put("sasl.jaas.config", jaasConfig);
            }
            Admin admin = Admin.create((Properties)properties);
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>(TestcontainersConfiguration.KAFKA_TOPICS.size());
            int partitions = TestcontainersConfiguration.KAFKA_TOPIC_PARTITION_COUNT;
            short replicationFactor = 1;
            for (String topicName : TestcontainersConfiguration.KAFKA_TOPICS) {
                NewTopic newTopic = new NewTopic(topicName, partitions, replicationFactor);
                newTopics.add(newTopic);
            }
            CreateTopicsResult result = admin.createTopics(newTopics);
            try {
                result.all().get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Topic creation failed.", (Throwable)e);
                throw new RuntimeException("Topic creation failed: " + e.getMessage(), e);
            }
            log.info("Created topics: " + TestcontainersConfiguration.KAFKA_TOPICS);
        }
    }

    private Slf4jLogConsumer getLogConsumer(String containerName) {
        return (Slf4jLogConsumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)("container." + containerName))).withRemoveAnsiCodes(false);
    }
}

