/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.kafka;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSchemaRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(KafkaSchemaRegistryClient.class);
    private static KafkaSchemaRegistryClient instance;
    private String schemaRegistryBaseUrl;
    private SchemaRegistryClient client;

    private KafkaSchemaRegistryClient() {
        String kafkaSchemaRegistryHost = Optional.ofNullable(System.getProperty("docker.host")).orElse("localhost");
        String kafkaSchemaRegistryPort = Optional.ofNullable(System.getProperty("kafka.schema.registry.mapped.port")).orElseThrow(() -> new RuntimeException("kafka.schema.registry.port property not found"));
        this.schemaRegistryBaseUrl = "http://" + kafkaSchemaRegistryHost + ":" + kafkaSchemaRegistryPort;
        log.info("Kafka schema registry base URL is: " + this.schemaRegistryBaseUrl);
        this.client = new CachedSchemaRegistryClient(this.schemaRegistryBaseUrl, 100);
    }

    public static synchronized KafkaSchemaRegistryClient getInstance() {
        if (instance == null) {
            instance = new KafkaSchemaRegistryClient();
        }
        return instance;
    }

    protected String getSchemaRegistryBaseUrl() {
        return this.schemaRegistryBaseUrl;
    }

    public void resetSchemaRegistry() throws Exception {
        this.client.reset();
        this.client.getAllSubjects().stream().forEach(subject -> {
            try {
                this.client.deleteSubject(subject);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public int registerSchema(String topic, String schema) throws Exception {
        AvroSchema avroSchema = new AvroSchema(schema);
        return this.client.register(topic + "-value", (ParsedSchema)avroSchema);
    }
}

