/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.extension;

import dev.lydtech.component.framework.extension.AdditionalContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestContainersConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TestContainersConfiguration.class);
    protected static final String CONTAINER_MAIN_LABEL_KEY = "dev.lydtech.main-container-label";
    private static final String DEFAULT_SERVICE_NAME = "app";
    private static final String DEFAULT_SERVICE_INSTANCE_COUNT = "1";
    private static final String DEFAULT_SERVICE_PORT = "9001";
    private static final String DEFAULT_SERVICE_DEBUG_PORT = "5001";
    private static final String DEFAULT_SERVICE_STARTUP_TIMEOUT_SECONDS = "180";
    private static final String DEFAULT_SERVICE_IMAGE_TAG = "latest";
    private static final String DEFAULT_SERVICE_CONTAINER_LOGGING_ENABLED = "false";
    private static final String DEFAULT_CONTAINER_NAME_PREFIX = "ct";
    private static final String DEFAULT_CONTAINER_MAIN_LABEL = "main-container";
    private static final String DEFAULT_POSTGRES_ENABLED = "false";
    private static final String DEFAULT_POSTGRES_IMAGE_TAG = "14-alpine";
    private static final String DEFAULT_POSTGRES_HOST_NAME = "postgres-host";
    private static final String DEFAULT_POSTGRES_PORT = "5432";
    private static final String DEFAULT_POSTGRES_DATABASE_NAME = "postgres-db";
    private static final String DEFAULT_POSTGRES_USERNAME = "user";
    private static final String DEFAULT_POSTGRES_PASSWORD = "password";
    private static final String DEFAULT_POSTGRES_CONTAINER_LOGGING_ENABLED = "false";
    private static final String DEFAULT_KAFKA_ENABLED = "false";
    private static final String DEFAULT_KAFKA_BROKER_COUNT = "1";
    private static final String DEFAULT_KAFKA_CONFLUENT_IMAGE_TAG = "7.3.2";
    private static final String DEFAULT_KAFKA_PORT = "9093";
    private static final String DEFAULT_KAFKA_TOPIC_PARTITION_COUNT = "1";
    private static final String DEFAULT_KAFKA_CONTAINER_LOGGING_ENABLED = "false";
    private static final String DEFAULT_KAFKA_TOPIC_REPLICATION_FACTOR = "1";
    private static final String DEFAULT_KAFKA_MIN_INSYNC_REPLICAS = "1";
    private static final String DEFAULT_DEBEZIUM_ENABLED = "false";
    private static final String DEFAULT_DEBEZIUM_IMAGE_TAG = "1.7.0.Final";
    private static final String DEFAULT_DEBEZIUM_PORT = "8083";
    private static final String DEFAULT_DEBEZIUM_CONTAINER_LOGGING_ENABLED = "false";
    private static final String DEFAULT_KAFKA_SCHEMA_REGISTRY_ENABLED = "false";
    private static final String DEFAULT_KAFKA_SCHEMA_REGISTRY_CONFLUENT_IMAGE_TAG = "7.3.2";
    private static final String DEFAULT_KAFKA_SCHEMA_REGISTRY_PORT = "8081";
    private static final String DEFAULT_KAFKA_SCHEMA_REGISTRY_CONTAINER_LOGGING_ENABLED = "false";
    private static final String DEFAULT_KAFKA_CONTROL_CENTER_ENABLED = "false";
    private static final String DEFAULT_KAFKA_CONTROL_CENTER_CONFLUENT_IMAGE_TAG = "7.3.2";
    private static final String DEFAULT_KAFKA_CONTROL_CENTER_PORT = "9021";
    private static final String DEFAULT_KAFKA_CONTROL_CENTER_JMX_PORT = "9101";
    private static final String DEFAULT_KAFKA_CONTROL_CENTER_EXPORT_METRICS_ENABLED = "false";
    private static final String DEFAULT_KAFKA_CONTROL_CENTER_CONTAINER_LOGGING_ENABLED = "false";
    private static final String DEFAULT_CONDUKTOR_IMAGE_TAG = "1.4.0";
    private static final String DEFAULT_CONDUKTOR_ENABLED = "false";
    private static final String DEFAULT_CONDUKTOR_CONTAINER_LOGGING_ENABLED = "false";
    private static final String DEFAULT_CONDUKTOR_PORT = "8088";
    private static final String DEFAULT_WIREMOCK_ENABLED = "false";
    private static final String DEFAULT_WIREMOCK_IMAGE_TAG = "2.32.0";
    private static final String DEFAULT_WIREMOCK_PORT = "8080";
    private static final String DEFAULT_WIREMOCK_CONTAINER_LOGGING_ENABLED = "false";
    private static final String DEFAULT_LOCALSTACK_ENABLED = "false";
    private static final String DEFAULT_LOCALSTACK_IMAGE_TAG = "0.14.3";
    private static final String DEFAULT_LOCALSTACK_PORT = "4566";
    private static final String DEFAULT_LOCALSTACK_SERVICES = "dynamodb";
    private static final String DEFAULT_LOCALSTACK_CONTAINER_LOGGING_ENABLED = "false";
    public static final String CONTAINER_NAME_PREFIX = System.getProperty("container.name.prefix", "ct");
    public static final String CONTAINER_MAIN_LABEL = System.getProperty("container.main.label", "main-container");
    public static final String SERVICE_NAME = System.getProperty("service.name", "app");
    public static final int SERVICE_INSTANCE_COUNT = Integer.parseInt(System.getProperty("service.instance.count", "1"));
    public static final int SERVICE_PORT = Integer.parseInt(System.getProperty("service.port", "9001"));
    public static final int SERVICE_DEBUG_PORT = Integer.parseInt(System.getProperty("service.debug.port", "5001"));
    public static final int SERVICE_STARTUP_TIMEOUT_SECONDS = Integer.parseInt(System.getProperty("service.startup.timeout.seconds", "180"));
    public static final String SERVICE_IMAGE_TAG = System.getProperty("service.image.tag", "latest");
    public static final boolean SERVICE_CONTAINER_LOGGING_ENABLED = Boolean.valueOf(System.getProperty("service.container.logging.enabled", "false"));
    public static final List<AdditionalContainer> ADDITIONAL_CONTAINERS = TestContainersConfiguration.parseAdditionalContainers();
    public static final boolean POSTGRES_ENABLED = Boolean.valueOf(System.getProperty("postgres.enabled", "false"));
    public static final String POSTGRES_IMAGE_TAG = System.getProperty("postgres.image.tag", "14-alpine");
    public static final String POSTGRES_HOST_NAME = System.getProperty("postgres.host.name", "postgres-host");
    public static final int POSTGRES_PORT = Integer.parseInt(System.getProperty("postgres.port", "5432"));
    public static final String POSTGRES_DATABASE_NAME = System.getProperty("postgres.database.name", "postgres-db");
    public static final String POSTGRES_USERNAME = System.getProperty("postgres.username", "user");
    public static final String POSTGRES_PASSWORD = System.getProperty("postgres.password", "password");
    public static final boolean POSTGRES_CONTAINER_LOGGING_ENABLED = Boolean.valueOf(System.getProperty("postgres.container.logging.enabled", "false"));
    public static final boolean KAFKA_ENABLED = Boolean.valueOf(System.getProperty("kafka.enabled", "false"));
    public static final int KAFKA_BROKER_COUNT = Integer.parseInt(System.getProperty("kafka.broker.count", "1"));
    public static final String KAFKA_CONFLUENT_IMAGE_TAG = System.getProperty("kafka.confluent.image.tag", "7.3.2");
    public static final int KAFKA_PORT = Integer.parseInt(System.getProperty("kafka.port", "9093"));
    public static final List<String> KAFKA_TOPICS = TestContainersConfiguration.parseKafkaTopics();
    public static final int KAFKA_TOPIC_PARTITION_COUNT = Integer.parseInt(System.getProperty("kafka.topic.partition.count", "1"));
    public static final boolean KAFKA_CONTAINER_LOGGING_ENABLED = Boolean.valueOf(System.getProperty("kafka.container.logging.enabled", "false"));
    public static final int KAFKA_TOPIC_REPLICATION_FACTOR = Integer.parseInt(System.getProperty("kafka.topic.replication.factor", "1"));
    public static final int KAFKA_MIN_INSYNC_REPLICAS = Integer.parseInt(System.getProperty("kafka.min.insync.replicas", "1"));
    public static final boolean KAFKA_SCHEMA_REGISTRY_ENABLED = Boolean.valueOf(System.getProperty("kafka.schema.registry.enabled", "false"));
    public static final String KAFKA_SCHEMA_REGISTRY_CONFLUENT_IMAGE_TAG = System.getProperty("kafka.schema.registry.confluent.image.tag", "7.3.2");
    public static final int KAFKA_SCHEMA_REGISTRY_PORT = Integer.parseInt(System.getProperty("kafka.schema.registry.port", "8081"));
    public static final boolean KAFKA_SCHEMA_REGISTRY_CONTAINER_LOGGING_ENABLED = Boolean.valueOf(System.getProperty("kafka.schema.registry.container.logging.enabled", "false"));
    public static final boolean KAFKA_CONTROL_CENTER_ENABLED = Boolean.valueOf(System.getProperty("kafka.control.center.enabled", "false"));
    public static final String KAFKA_CONTROL_CENTER_CONFLUENT_IMAGE_TAG = System.getProperty("kafka.control.center.confluent.image.tag", "7.3.2");
    public static final boolean KAFKA_CONTROL_CENTER_EXPORT_METRICS_ENABLED = Boolean.valueOf(System.getProperty("kafka.control.center.export.metrics.enabled", "false"));
    public static final String KAFKA_CONTROL_CENTER_JMX_PORT = System.getProperty("kafka.control.center.jmx.port", "9101");
    public static final int KAFKA_CONTROL_CENTER_PORT = Integer.parseInt(System.getProperty("kafka.control.center.port", "9021"));
    public static final boolean KAFKA_CONTROL_CENTER_CONTAINER_LOGGING_ENABLED = Boolean.valueOf(System.getProperty("kafka.control.center.container.logging.enabled", "false"));
    public static final boolean CONDUKTOR_ENABLED = Boolean.valueOf(System.getProperty("conduktor.enabled", "false"));
    public static final String CONDUKTOR_IMAGE_TAG = System.getProperty("conduktor.image.tag", "1.4.0");
    public static final String CONDUKTOR_LICENSE_KEY = System.getProperty("conduktor.license.key");
    public static final int CONDUKTOR_PORT = Integer.parseInt(System.getProperty("conduktor.port", "8088"));
    public static final boolean CONDUKTOR_CONTAINER_LOGGING_ENABLED = Boolean.valueOf(System.getProperty("conduktor.container.logging.enabled", "false"));
    public static final boolean DEBEZIUM_ENABLED = Boolean.valueOf(System.getProperty("debezium.enabled", "false"));
    public static final String DEBEZIUM_IMAGE_TAG = System.getProperty("debezium.image.tag", "1.7.0.Final");
    public static final int DEBEZIUM_PORT = Integer.parseInt(System.getProperty("debezium.port", "8083"));
    public static final boolean DEBEZIUM_CONTAINER_LOGGING_ENABLED = Boolean.valueOf(System.getProperty("debezium.container.logging.enabled", "false"));
    public static final boolean WIREMOCK_ENABLED = Boolean.valueOf(System.getProperty("wiremock.enabled", "false"));
    public static final String WIREMOCK_IMAGE_TAG = System.getProperty("wiremock.image.tag", "2.32.0");
    public static final int WIREMOCK_PORT = Integer.parseInt("8080");
    public static final boolean WIREMOCK_CONTAINER_LOGGING_ENABLED = Boolean.valueOf(System.getProperty("wiremock.container.logging.enabled", "false"));
    public static final boolean LOCALSTACK_ENABLED = Boolean.valueOf(System.getProperty("localstack.enabled", "false"));
    public static final String LOCALSTACK_IMAGE_TAG = System.getProperty("localstack.image.tag", "0.14.3");
    public static final int LOCALSTACK_PORT = Integer.parseInt(System.getProperty("localstack.port", "4566"));
    public static final String LOCALSTACK_SERVICES = System.getProperty("localstack.services", "dynamodb");
    public static final boolean LOCALSTACK_CONTAINER_LOGGING_ENABLED = Boolean.valueOf(System.getProperty("localstack.container.logging.enabled", "false"));

    private static List<AdditionalContainer> parseAdditionalContainers() {
        String additionalContainersPropertyValue = System.getProperty("additional.containers", null);
        log.debug("Parsing additional containers: {}", (Object)additionalContainersPropertyValue);
        List additionalContainers = Collections.EMPTY_LIST;
        if (additionalContainersPropertyValue != null && (additionalContainersPropertyValue = additionalContainersPropertyValue.replaceAll("\\s+", "")).length() > 0) {
            List<String> containerDetailStrings = Arrays.asList(additionalContainersPropertyValue.split(":"));
            additionalContainers = containerDetailStrings.stream().map(containerDetail -> {
                log.debug("Parsing individual additional container: {}", containerDetail);
                List<String> parsedDetails = Arrays.asList(containerDetail.split(","));
                if (parsedDetails.size() != 5) {
                    String message = "Invalid additional containers details: " + parsedDetails + " -  expecting 5 args, found " + parsedDetails.size() + ".";
                    log.error(message);
                    throw new RuntimeException(message);
                }
                return AdditionalContainer.builder().name(parsedDetails.get(0)).port(Integer.parseInt(parsedDetails.get(1))).debugPort(Integer.parseInt(parsedDetails.get(2))).imageTag(parsedDetails.get(3)).additionalContainerLoggingEnabled(Boolean.valueOf(parsedDetails.get(4))).build();
            }).collect(Collectors.toList());
        }
        return additionalContainers;
    }

    private static List<String> parseKafkaTopics() {
        String topicNamesPropertyValue = System.getProperty("kafka.topics", null);
        List<String> topics = Collections.EMPTY_LIST;
        if (topicNamesPropertyValue != null && (topicNamesPropertyValue = topicNamesPropertyValue.replaceAll("\\s+", "")).length() > 0) {
            topics = Arrays.asList(topicNamesPropertyValue.split(","));
        }
        return topics;
    }

    static {
        log.info("TestContainers Configuration:");
        log.info("containers.stayup: " + System.getProperty("containers.stayup", Boolean.FALSE.toString()));
        log.info("container.name.prefix: " + CONTAINER_NAME_PREFIX);
        log.info("container.main.label: " + CONTAINER_MAIN_LABEL);
        log.info("service.name: " + SERVICE_NAME);
        log.info("service.instance.count: " + SERVICE_INSTANCE_COUNT);
        log.info("service.port: " + SERVICE_PORT);
        log.info("service.debug.port: " + SERVICE_DEBUG_PORT);
        log.info("service.startup.timeout.seconds: " + SERVICE_STARTUP_TIMEOUT_SECONDS);
        log.info("service.image.tag: " + SERVICE_IMAGE_TAG);
        log.info("service.container.logging.enabled: " + SERVICE_CONTAINER_LOGGING_ENABLED);
        log.info("additional.containers: " + System.getProperty("additional.containers", ""));
        log.info("postgres.enabled: " + POSTGRES_ENABLED);
        if (POSTGRES_ENABLED) {
            log.info("postgres.image.tag: " + POSTGRES_IMAGE_TAG);
            log.info("postgres.host.name: " + POSTGRES_HOST_NAME);
            log.info("postgres.port: " + POSTGRES_PORT);
            log.info("postgres.database.name: " + POSTGRES_DATABASE_NAME);
            log.info("postgres.username: " + POSTGRES_USERNAME);
            log.info("postgres.password: " + POSTGRES_PASSWORD);
            log.info("postgres.container.logging.enabled: " + KAFKA_CONTAINER_LOGGING_ENABLED);
        }
        log.info("kafka.enabled: " + KAFKA_ENABLED);
        if (KAFKA_ENABLED) {
            log.info("kafka.confluent.image.tag: " + KAFKA_CONFLUENT_IMAGE_TAG);
            log.info("kafka.broker.count: " + KAFKA_BROKER_COUNT);
            log.info("kafka.port: " + KAFKA_PORT);
            log.info("kafka.topics: " + KAFKA_TOPICS);
            log.info("kafka.topic.partition.count: " + KAFKA_TOPIC_PARTITION_COUNT);
            log.info("kafka.topic.replication.factor: " + KAFKA_TOPIC_REPLICATION_FACTOR);
            log.info("kafka.min.insync.replicas: " + KAFKA_MIN_INSYNC_REPLICAS);
            log.info("kafka.container.logging.enabled: " + KAFKA_CONTAINER_LOGGING_ENABLED);
        }
        log.info("kafka.schema.registry.enabled: " + KAFKA_SCHEMA_REGISTRY_ENABLED);
        if (KAFKA_SCHEMA_REGISTRY_ENABLED) {
            log.info("kafka.schema.registry.confluent.image.tag: " + KAFKA_SCHEMA_REGISTRY_CONFLUENT_IMAGE_TAG);
            log.info("kafka.schema.registry.port: " + KAFKA_SCHEMA_REGISTRY_PORT);
            log.info("kafka.schema.registry.container.logging.enabled: " + KAFKA_SCHEMA_REGISTRY_CONTAINER_LOGGING_ENABLED);
        }
        log.info("kafka.control.center.enabled: " + KAFKA_CONTROL_CENTER_ENABLED);
        if (KAFKA_CONTROL_CENTER_ENABLED) {
            log.info("kafka.control.center.confluent.image.tag: " + KAFKA_CONTROL_CENTER_CONFLUENT_IMAGE_TAG);
            log.info("kafka.control.center.port: " + KAFKA_CONTROL_CENTER_PORT);
            log.info("kafka.control.center.export.metrics.enabled: " + KAFKA_CONTROL_CENTER_EXPORT_METRICS_ENABLED);
            log.info("kafka.control.center.jmx.port: " + KAFKA_CONTROL_CENTER_JMX_PORT);
            if (KAFKA_CONTROL_CENTER_EXPORT_METRICS_ENABLED) {
                log.info("Kafka Control Center metrics require Confluent's community package kafka-clients and monitoring-interceptors libraries.");
            }
            log.info("kafka.control.center.container.logging.enabled: " + KAFKA_CONTROL_CENTER_CONTAINER_LOGGING_ENABLED);
        }
        log.info("conduktor.enabled: " + CONDUKTOR_ENABLED);
        if (CONDUKTOR_ENABLED) {
            log.info("conduktor.image.tag: " + CONDUKTOR_IMAGE_TAG);
            log.info("conduktor.license.key: " + CONDUKTOR_LICENSE_KEY);
            log.info("conduktor.port: " + CONDUKTOR_PORT);
            log.info("conduktor.container.logging.enabled: " + CONDUKTOR_CONTAINER_LOGGING_ENABLED);
        }
        log.info("debezium.enabled: " + DEBEZIUM_ENABLED);
        if (DEBEZIUM_ENABLED) {
            log.info("debezium.image.tag: " + DEBEZIUM_IMAGE_TAG);
            log.info("debezium.port: " + DEBEZIUM_PORT);
            log.info("debezium.container.logging.enabled: " + DEBEZIUM_CONTAINER_LOGGING_ENABLED);
        }
        log.info("wiremock.enabled: " + WIREMOCK_ENABLED);
        if (WIREMOCK_ENABLED) {
            log.info("wiremock.image.tag: " + WIREMOCK_IMAGE_TAG);
            log.info("wiremock.port: " + WIREMOCK_PORT);
            log.info("wiremock.container.logging.enabled: " + WIREMOCK_CONTAINER_LOGGING_ENABLED);
        }
        log.info("localstack.enabled: " + LOCALSTACK_ENABLED);
        if (LOCALSTACK_ENABLED) {
            log.info("localstack.image.tag: " + LOCALSTACK_IMAGE_TAG);
            log.info("localstack.port: " + LOCALSTACK_PORT);
            log.info("localstack.services: " + LOCALSTACK_SERVICES);
            log.info("localstack.container.logging.enabled: " + LOCALSTACK_CONTAINER_LOGGING_ENABLED);
        }
    }
}

