/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.extension;

import dev.lydtech.component.framework.extension.TestContainersConfiguration;
import dev.lydtech.component.framework.resource.Resource;
import io.debezium.testing.testcontainers.DebeziumContainer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public final class TestContainersManager {
    private static final Logger log = LoggerFactory.getLogger(TestContainersManager.class);
    private Network network;
    private List<GenericContainer> serviceContainers;
    private List<GenericContainer> additionalContainers;
    private GenericContainer postgresContainer;
    private KafkaContainer kafkaContainer;
    private DebeziumContainer debeziumContainer;
    private GenericContainer kafkaSchemaRegistryContainer;
    private GenericContainer wiremockContainer;
    private GenericContainer localstackContainer;

    private TestContainersManager() {
    }

    protected static void initialise() {
        TestContainersManager manager = new TestContainersManager();
        log.info("Creating test containers...");
        manager.createContainers();
        log.info("Starting test containers...");
        manager.startContainers();
        log.info("Started test containers.");
    }

    private void createContainers() {
        if (TestContainersConfiguration.SERVICE_INSTANCE_COUNT < 1) {
            throw new RuntimeException("At least one service container should be started");
        }
        this.network = Network.newNetwork();
        if (TestContainersConfiguration.POSTGRES_ENABLED) {
            this.postgresContainer = this.createPostgresContainer();
        }
        if (TestContainersConfiguration.KAFKA_ENABLED) {
            this.kafkaContainer = this.createKafkaContainer();
        }
        if (TestContainersConfiguration.DEBEZIUM_ENABLED) {
            if (!TestContainersConfiguration.KAFKA_ENABLED || !TestContainersConfiguration.POSTGRES_ENABLED) {
                throw new RuntimeException("Kafka and Postgres must be enabled in order to use Debezium.");
            }
            this.debeziumContainer = this.createDebeziumContainer();
        }
        if (TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_ENABLED) {
            if (!TestContainersConfiguration.KAFKA_ENABLED) {
                throw new RuntimeException("Kafka must be enabled in order to use Kafka schema registry.");
            }
            this.kafkaSchemaRegistryContainer = this.createKafkaSchemaRegistryContainer();
        }
        if (TestContainersConfiguration.WIREMOCK_ENABLED) {
            this.wiremockContainer = this.createWiremockContainer();
        }
        if (TestContainersConfiguration.LOCALSTACK_ENABLED) {
            this.localstackContainer = this.createLocalstackContainer();
        }
        this.serviceContainers = IntStream.range(1, TestContainersConfiguration.SERVICE_INSTANCE_COUNT + 1).mapToObj(this::createServiceContainer).collect(Collectors.toList());
        this.additionalContainers = TestContainersConfiguration.ADDITIONAL_CONTAINERS.stream().map(additionalContainer -> this.createAdditionalContainer(additionalContainer.getName(), additionalContainer.getPort(), additionalContainer.getDebugPort(), additionalContainer.getImageTag(), additionalContainer.getAdditionalContainerLoggingEnabled())).collect(Collectors.toList());
    }

    private void startContainers() {
        try {
            if (TestContainersConfiguration.POSTGRES_ENABLED) {
                this.postgresContainer.start();
            }
            if (TestContainersConfiguration.KAFKA_ENABLED) {
                this.kafkaContainer.start();
                this.createTopics();
            }
            if (TestContainersConfiguration.DEBEZIUM_ENABLED) {
                this.debeziumContainer.start();
            }
            if (TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_ENABLED) {
                this.kafkaSchemaRegistryContainer.start();
            }
            if (TestContainersConfiguration.WIREMOCK_ENABLED) {
                this.wiremockContainer.start();
            }
            if (TestContainersConfiguration.LOCALSTACK_ENABLED) {
                this.localstackContainer.start();
            }
            this.serviceContainers.stream().forEach(container -> container.start());
            this.additionalContainers.stream().forEach(container -> container.start());
        }
        catch (Exception e) {
            log.error("Component test containers failed to start", (Throwable)e);
            throw e;
        }
    }

    private GenericContainer createServiceContainer(int instance) {
        String containerName = TestContainersConfiguration.SERVICE_NAME + "-" + instance;
        String javaOpts = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:" + TestContainersConfiguration.SERVICE_DEBUG_PORT + " -Xms512m -Xmx512m -Djava.security.egd=file:/dev/./urandom -Dspring.config.additional-location=file:/application.yml";
        GenericContainer container = new GenericContainer(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "/" + TestContainersConfiguration.SERVICE_NAME + ":" + TestContainersConfiguration.SERVICE_IMAGE_TAG).withEnv("JAVA_OPTS", javaOpts).withLabel("dev.lydtech.main-container-label", TestContainersConfiguration.CONTAINER_MAIN_LABEL).withFileSystemBind("./target/test-classes/application-component-test.yml", "/application.yml", BindMode.READ_ONLY).withExposedPorts(new Integer[]{TestContainersConfiguration.SERVICE_PORT, TestContainersConfiguration.SERVICE_DEBUG_PORT}).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).waitingFor(Wait.forHttp((String)"/actuator/health").forPort(TestContainersConfiguration.SERVICE_PORT).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(TestContainersConfiguration.SERVICE_STARTUP_TIMEOUT_SECONDS)));
        if (TestContainersConfiguration.SERVICE_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createAdditionalContainer(String name, Integer port, Integer debugPort, String imageTag, boolean containerLoggingEnabled) {
        String javaOpts = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:" + debugPort + " -Xms512m -Xmx512m -Djava.security.egd=file:/dev/./urandom -Dspring.config.additional-location=file:/application.yml";
        GenericContainer container = new GenericContainer(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "/" + name + ":" + imageTag).withEnv("JAVA_OPTS", javaOpts).withFileSystemBind("./target/test-classes/" + name + "/application-component-test.yml", "/application.yml", BindMode.READ_ONLY).withExposedPorts(new Integer[]{port, debugPort}).withNetwork(this.network).withNetworkAliases(new String[]{name}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + name)).waitingFor(Wait.forHttp((String)"/actuator/health").forPort(port.intValue()).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(TestContainersConfiguration.SERVICE_STARTUP_TIMEOUT_SECONDS)));
        if (containerLoggingEnabled) {
            container.withLogConsumer((Consumer)this.getLogConsumer(name));
        }
        return container;
    }

    private GenericContainer createPostgresContainer() {
        String containerName = Resource.POSTGRES.toString();
        GenericContainer container = ((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"debezium/postgres").asCompatibleSubstituteFor("postgres").withTag(TestContainersConfiguration.POSTGRES_IMAGE_TAG)).withDatabaseName(TestContainersConfiguration.POSTGRES_DATABASE_NAME).withUsername(TestContainersConfiguration.POSTGRES_USERNAME).withPassword(TestContainersConfiguration.POSTGRES_PASSWORD).withNetwork(this.network)).withNetworkAliases(new String[]{TestContainersConfiguration.POSTGRES_HOST_NAME})).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName))).withExposedPorts(new Integer[]{TestContainersConfiguration.POSTGRES_PORT});
        if (TestContainersConfiguration.POSTGRES_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private KafkaContainer createKafkaContainer() {
        String containerName = Resource.KAFKA.toString();
        KafkaContainer container = (KafkaContainer)((KafkaContainer)((KafkaContainer)new KafkaContainer(DockerImageName.parse((String)"confluentinc/cp-kafka").withTag(TestContainersConfiguration.KAFKA_CONFLUENT_IMAGE_TAG)).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        if (TestContainersConfiguration.KAFKA_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private DebeziumContainer createDebeziumContainer() {
        String containerName = Resource.DEBEZIUM.toString();
        DebeziumContainer container = (DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)new DebeziumContainer(DockerImageName.parse((String)"debezium/connect").withTag(TestContainersConfiguration.DEBEZIUM_IMAGE_TAG)).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withKafka(this.kafkaContainer).withExposedPorts(new Integer[]{TestContainersConfiguration.DEBEZIUM_PORT})).dependsOn(new Startable[]{this.kafkaContainer})).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        if (TestContainersConfiguration.DEBEZIUM_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createKafkaSchemaRegistryContainer() {
        String containerName = Resource.KAFKA_SCHEMA_REGISTRY.toString().replace("_", "-");
        GenericContainer container = new GenericContainer("confluentinc/cp-schema-registry:" + TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_CONFLUENT_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).withExposedPorts(new Integer[]{TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_PORT}).withEnv("SCHEMA_REGISTRY_HOST_NAME", containerName).withEnv("SCHEMA_REGISTRY_KAFKASTORE_BOOTSTRAP_SERVERS", Resource.KAFKA.toString() + ":9092").dependsOn(new Startable[]{this.kafkaContainer});
        if (TestContainersConfiguration.KAFKA_SCHEMA_REGISTRY_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createWiremockContainer() {
        String containerName = Resource.WIREMOCK.toString();
        GenericContainer container = new GenericContainer("wiremock/wiremock:" + TestContainersConfiguration.WIREMOCK_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).withClasspathResourceMapping("/wiremock", "/home/wiremock/mappings", BindMode.READ_WRITE).withExposedPorts(new Integer[]{TestContainersConfiguration.WIREMOCK_PORT}).waitingFor((WaitStrategy)Wait.forHttp((String)"/health").forStatusCode(204));
        if (TestContainersConfiguration.WIREMOCK_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createLocalstackContainer() {
        String containerName = Resource.LOCALSTACK.toString();
        GenericContainer container = new GenericContainer("localstack/localstack:" + TestContainersConfiguration.LOCALSTACK_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).withEnv("SERVICES", TestContainersConfiguration.LOCALSTACK_SERVICES).withExposedPorts(new Integer[]{TestContainersConfiguration.LOCALSTACK_PORT});
        if (TestContainersConfiguration.LOCALSTACK_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private void createTopics() {
        if (!TestContainersConfiguration.KAFKA_TOPICS.isEmpty()) {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", this.kafkaContainer.getBootstrapServers());
            Admin admin = Admin.create((Properties)properties);
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>(TestContainersConfiguration.KAFKA_TOPICS.size());
            int partitions = TestContainersConfiguration.KAFKA_TOPIC_PARTITION_COUNT;
            short replicationFactor = 1;
            for (String topicName : TestContainersConfiguration.KAFKA_TOPICS) {
                NewTopic newTopic = new NewTopic(topicName, partitions, replicationFactor);
                newTopics.add(newTopic);
            }
            CreateTopicsResult result = admin.createTopics(newTopics);
            try {
                result.all().get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Topic creation failed.", (Throwable)e);
                throw new RuntimeException("Topic creation failed: " + e.getMessage(), e);
            }
            log.info("Created topics: " + TestContainersConfiguration.KAFKA_TOPICS);
        }
    }

    private Slf4jLogConsumer getLogConsumer(String containerName) {
        return (Slf4jLogConsumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)("container." + containerName))).withRemoveAnsiCodes(false);
    }
}

