package dev.lydtech.component.framework.service;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceAdminClient {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceAdminClient.class);

    private static String serviceBaseUrl;

    private static ServiceAdminClient instance;

    private ServiceAdminClient(){}

    public synchronized static ServiceAdminClient getInstance() {
        if(instance==null) {
            String serviceHost = Optional.ofNullable(System.getProperty("service.host"))
                    .orElse("localhost");
            String servicePort = Optional.ofNullable(System.getProperty("service.mapped.port"))
                    .orElseThrow(() -> new RuntimeException("service.mapped.port property not found"));
            serviceBaseUrl = "http://" + serviceHost + ":" + servicePort;
            LOG.info("Service base URL is: " + serviceBaseUrl);
            instance = new ServiceAdminClient();
        }
        return instance;
    }

    public String getServiceBaseUrl() {
        return serviceBaseUrl;
    }
}
