/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.kafka;

import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducerFactory {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducerFactory.class);
    private final String brokerUrl;

    public KafkaProducerFactory(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public Producer<Long, String> createProducer() {
        Properties config = new Properties();
        config.put("bootstrap.servers", this.brokerUrl);
        config.put("key.serializer", StringSerializer.class);
        config.put("value.serializer", StringSerializer.class);
        log.debug("Kafka producer is created with brokerUrl={}", (Object)this.brokerUrl);
        return new KafkaProducer(config);
    }
}

