/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.kafka;

import java.util.Collections;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerFactory {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerFactory.class);
    private final String brokerUrl;
    private final String groupId;

    public KafkaConsumerFactory(String brokerUrl, String groupId) {
        this.brokerUrl = brokerUrl;
        this.groupId = groupId;
    }

    public Consumer<Integer, String> createAndSubscribe(String topic) {
        Properties config = new Properties();
        String extendedGroupId = this.groupId + topic;
        log.debug("Creating consumer with brokerUrl={}, groupID={} and topic={}", new Object[]{this.brokerUrl, extendedGroupId, topic});
        config.put("bootstrap.servers", this.brokerUrl);
        config.put("group.id", extendedGroupId);
        config.put("key.deserializer", StringDeserializer.class);
        config.put("value.deserializer", StringDeserializer.class);
        config.put("auto.offset.reset", "latest");
        config.put("enable.auto.commit", "true");
        config.put("metadata.max.age.ms", (Object)1000);
        KafkaConsumer consumer = new KafkaConsumer(config);
        consumer.subscribe(Collections.singletonList(topic));
        log.debug("Kafka consumer is created and subscribed to topic: {}", (Object)consumer.subscription());
        return consumer;
    }
}

