/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.kafka;

import dev.lydtech.component.framework.kafka.KafkaConsumerFactory;
import dev.lydtech.component.framework.kafka.KafkaProducerFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBrokerUtils {
    private static final Logger log = LoggerFactory.getLogger(KafkaBrokerUtils.class);
    private static final String KEY_BROKER_URL = "brokerUrl";
    private static final String KEY_GROUPID = "groupId";
    private static final String DEFAULT_BROKER_HOST = "localhost";
    private final KafkaConsumerFactory kafkaConsumerFactory;
    private final KafkaProducerFactory kafkaProducerFactory;

    public KafkaBrokerUtils(Map<String, Object> config) {
        this((String)config.get(KEY_BROKER_URL), (String)config.get(KEY_GROUPID));
    }

    public KafkaBrokerUtils(String brokerUrl, String groupId) {
        this.kafkaConsumerFactory = new KafkaConsumerFactory(brokerUrl, groupId);
        this.kafkaProducerFactory = new KafkaProducerFactory(brokerUrl);
        log.debug("Created Kafka message broker utils with brokerUrl={} and groupID={}", (Object)brokerUrl, (Object)groupId);
    }

    public static KafkaBrokerUtils createBroker(String kafkaGroupId) {
        Map<String, Object> config = KafkaBrokerUtils.getKafkaConfig(kafkaGroupId);
        return KafkaBrokerUtils.createBroker(config);
    }

    public static KafkaBrokerUtils createBroker(Map<String, Object> config) {
        return new KafkaBrokerUtils(config);
    }

    private static Map<String, Object> getKafkaConfig(String kafkaGroupId) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        Integer kafkaPort = Optional.ofNullable(System.getProperty("kafka.port")).map(Integer::parseInt).orElseThrow(() -> new RuntimeException("Kafka port not set"));
        config.put(KEY_BROKER_URL, "tcp://localhost:" + kafkaPort);
        config.put(KEY_GROUPID, kafkaGroupId);
        return config;
    }

    public void sendMessage(String topic, String key, String payload) throws Exception {
        ProducerRecord record = new ProducerRecord(topic, null, (Object)key, (Object)payload);
        RecordMetadata metadata = (RecordMetadata)this.kafkaProducerFactory.createProducer().send(record).get();
        log.debug(String.format("Sent record(key=%s value=%s) meta(topic=%s, partition=%d, offset=%d)", record.key(), record.value(), metadata.topic(), metadata.partition(), metadata.offset()));
    }

    public Consumer createConsumer(String topic) {
        return this.kafkaConsumerFactory.createAndSubscribe(topic);
    }

    public List<ConsumerRecord<String, String>> consumeAndAssert(String testName, Consumer consumer, int expectedEventCount, int furtherPolls) throws Exception {
        AtomicInteger totalReceivedEvents = new AtomicInteger();
        AtomicInteger totalExtraPolls = new AtomicInteger(-1);
        AtomicInteger pollCount = new AtomicInteger();
        ArrayList<ConsumerRecord<String, String>> events = new ArrayList<ConsumerRecord<String, String>>();
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> {
            ConsumerRecords consumerRecords = consumer.poll(Duration.ofMillis(100L));
            consumerRecords.forEach(record -> {
                log.info(testName + " - received: " + (String)record.value());
                totalReceivedEvents.incrementAndGet();
                events.add((ConsumerRecord<String, String>)record);
            });
            if (totalReceivedEvents.get() == expectedEventCount) {
                totalExtraPolls.incrementAndGet();
            }
            pollCount.getAndIncrement();
            log.info(testName + " - poll count: " + pollCount.get() + " - received count: " + totalReceivedEvents.get());
            return totalReceivedEvents.get() == expectedEventCount && totalExtraPolls.get() == furtherPolls;
        });
        return events;
    }
}

