/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.extension;

import dev.lydtech.component.framework.extension.TestContainersConfiguration;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public final class TestContainersManager {
    private static final Logger log = LoggerFactory.getLogger(TestContainersManager.class);
    private final Network network;
    private final List<GenericContainer> serviceContainers;
    private KafkaContainer kafkaContainer;

    protected TestContainersManager() {
        if (TestContainersConfiguration.SERVICE_INSTANCE_COUNT < 1) {
            throw new RuntimeException("At least one service container should be started");
        }
        this.network = Network.newNetwork();
        if (TestContainersConfiguration.KAFKA_ENABLED) {
            this.kafkaContainer = this.createKafkaContainer("kafka", 0);
        }
        this.serviceContainers = IntStream.range(0, TestContainersConfiguration.SERVICE_INSTANCE_COUNT).mapToObj(this::createServiceContainer).collect(Collectors.toList());
    }

    protected GenericContainer createServiceContainer(int replica) {
        String configFileName = "/application.yml";
        String javaOpts = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:" + TestContainersConfiguration.SERVICE_DEBUG_PORT + " -Xms512m -Xmx512m -Djava.security.egd=file:/dev/./urandom -Dspring.config.additional-location=file:" + configFileName;
        log.debug("JAVA_OPTS: {}", (Object)javaOpts);
        GenericContainer container = this.genericContainer(TestContainersConfiguration.SERVICE_NAME, TestContainersConfiguration.CONTAINER_NAME_PREFIX + "/" + TestContainersConfiguration.SERVICE_NAME + ":" + TestContainersConfiguration.SERVICE_IMAGE_TAG, replica).withEnv("JAVA_OPTS", javaOpts).withFileSystemBind("./target/test-classes/application-component-test.yml", "/application.yml", BindMode.READ_ONLY).withExposedPorts(new Integer[]{TestContainersConfiguration.SERVICE_PORT, TestContainersConfiguration.SERVICE_DEBUG_PORT}).waitingFor(Wait.forHttp((String)"/actuator/health").forPort(TestContainersConfiguration.SERVICE_PORT).forStatusCode(200).withStartupTimeout(this.getServiceStartupTimeout()));
        return container;
    }

    protected void startContainers() {
        try {
            if (TestContainersConfiguration.KAFKA_ENABLED) {
                this.kafkaContainer.start();
                this.createTopics();
            }
            this.serviceContainers.stream().forEach(container -> container.start());
        }
        catch (Exception e) {
            log.error("Component test containers failed to start", (Throwable)e);
            throw e;
        }
    }

    private void createTopics() {
        if (!TestContainersConfiguration.KAFKA_TOPICS.isEmpty()) {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", this.kafkaContainer.getBootstrapServers());
            Admin admin = Admin.create((Properties)properties);
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>(TestContainersConfiguration.KAFKA_TOPICS.size());
            int partitions = TestContainersConfiguration.KAFKA_TOPIC_PARTITION_COUNT;
            short replicationFactor = 1;
            for (String topicName : TestContainersConfiguration.KAFKA_TOPICS) {
                NewTopic newTopic = new NewTopic(topicName, partitions, replicationFactor);
                newTopics.add(newTopic);
            }
            CreateTopicsResult result = admin.createTopics(newTopics);
            try {
                result.all().get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Topic creation failed.", (Throwable)e);
                throw new RuntimeException("Topic creation failed: " + e.getMessage(), e);
            }
            log.info("Created topics: " + TestContainersConfiguration.KAFKA_TOPICS);
        }
    }

    private Duration getServiceStartupTimeout() {
        return Duration.ofSeconds(TestContainersConfiguration.SERVICE_STARTUP_TIMEOUT_SECONDS);
    }

    private GenericContainer genericContainer(String serviceName, String imageName, int replica) {
        String containerName = this.getContainerName(serviceName, replica);
        GenericContainer container = new GenericContainer(imageName).withNetwork(this.network).withNetworkAliases(this.populateNetworkAliases(serviceName, replica, containerName).toArray(new String[0])).withCreateContainerCmdModifier(cmd -> {
            if (TestContainersConfiguration.CONTAINER_NAME_PREFIX != null) {
                cmd.withName(String.format("%s-%s", TestContainersConfiguration.CONTAINER_NAME_PREFIX, containerName));
            }
        });
        if (TestContainersConfiguration.SERVICE_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogger(containerName));
        }
        return container;
    }

    private KafkaContainer createKafkaContainer(String serviceName, int replica) {
        String containerName = this.getContainerName(serviceName, replica);
        KafkaContainer container = (KafkaContainer)((KafkaContainer)((KafkaContainer)new KafkaContainer(DockerImageName.parse((String)"confluentinc/cp-kafka").withTag(TestContainersConfiguration.KAFKA_CONFLUENT_IMAGE_VERSION)).withNetwork(this.network)).withNetworkAliases(this.populateNetworkAliases(serviceName, replica, containerName).toArray(new String[0]))).withCreateContainerCmdModifier(cmd -> {
            if (TestContainersConfiguration.CONTAINER_NAME_PREFIX != null) {
                cmd.withName(String.format("%s-%s", TestContainersConfiguration.CONTAINER_NAME_PREFIX, containerName));
            }
        });
        if (TestContainersConfiguration.KAFKA_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogger(containerName));
        }
        return container;
    }

    private Slf4jLogConsumer getLogger(String containerName) {
        return (Slf4jLogConsumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)String.format("container.%s", containerName))).withRemoveAnsiCodes(false);
    }

    private String getContainerName(String serviceName, int replica) {
        return serviceName + "-" + replica;
    }

    private List<String> populateNetworkAliases(String serviceName, int replica, String containerName) {
        ArrayList<String> networkAliases = new ArrayList<String>();
        networkAliases.add(containerName);
        if (replica == 0) {
            networkAliases.add(serviceName);
        }
        return networkAliases;
    }
}

