/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.extension;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestContainersConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TestContainersConfiguration.class);
    private static final String DEFAULT_SERVICE_NAME = "app";
    private static final String DEFAULT_SERVICE_INSTANCE_COUNT = "1";
    private static final String DEFAULT_SERVICE_PORT = "9001";
    private static final String DEFAULT_SERVICE_DEBUG_PORT = "5001";
    private static final String DEFAULT_SERVICE_STARTUP_TIMEOUT_SECONDS = "180";
    private static final String DEFAULT_SERVICE_IMAGE_TAG = "latest";
    private static final String DEFAULT_SERVICE_CONTAINER_LOGGING_ENABLED = "false";
    private static final String DEFAULT_CONTAINER_NAME_PREFIX = "ct";
    private static final String DEFAULT_KAFKA_ENABLED = "true";
    private static final String DEFAULT_KAFKA_CONFLUENT_IMAGE_VERSION = "5.3.1";
    private static final String DEFAULT_KAFKA_PORT = "9093";
    private static final String DEFAULT_KAFKA_TOPIC_PARTITION_COUNT = "5";
    private static final String DEFAULT_KAFKA_CONTAINER_LOGGING_ENABLED = "false";
    public static final String SERVICE_NAME = System.getProperty("service.name", "app");
    public static final int SERVICE_INSTANCE_COUNT = Integer.parseInt(System.getProperty("service.instance.count", "1"));
    public static final int SERVICE_PORT = Integer.parseInt(System.getProperty("service.port", "9001"));
    public static final int SERVICE_DEBUG_PORT = Integer.parseInt(System.getProperty("service.debug.port", "5001"));
    public static final int SERVICE_STARTUP_TIMEOUT_SECONDS = Integer.parseInt(System.getProperty("service.startup.timeout.seconds", "180"));
    public static final String SERVICE_IMAGE_TAG = System.getProperty("service.image.tag", "latest");
    public static final boolean SERVICE_CONTAINER_LOGGING_ENABLED = Boolean.valueOf(System.getProperty("service.container.logging.enabled", "false"));
    public static final String CONTAINER_NAME_PREFIX = System.getProperty("container.name.prefix", "ct");
    public static final boolean KAFKA_ENABLED = Boolean.valueOf(System.getProperty("kafka.enabled", "true"));
    public static final String KAFKA_CONFLUENT_IMAGE_VERSION = System.getProperty("kafka.confluent.image.version", "5.3.1");
    public static final boolean KAFKA_CONTAINER_LOGGING_ENABLED = Boolean.valueOf(System.getProperty("kafka.container.logging.enabled", "false"));
    public static final int KAFKA_PORT = Integer.parseInt(System.getProperty("kafka.port", "9093"));
    public static final List<String> KAFKA_TOPICS = TestContainersConfiguration.parseTopics();
    public static final int KAFKA_TOPIC_PARTITION_COUNT = Integer.parseInt(System.getProperty("kafka.topic.partition.count", "5"));

    private static List<String> parseTopics() {
        String topicNamesPropertyValue = System.getProperty("kafka.topics", null);
        List<String> topics = Collections.EMPTY_LIST;
        if (topicNamesPropertyValue != null && (topicNamesPropertyValue = topicNamesPropertyValue.replaceAll("\\s+", "")).length() > 0) {
            topics = Arrays.asList(topicNamesPropertyValue.split(","));
        }
        return topics;
    }

    static {
        log.info("TestContainers Configuration:");
        log.info("service.name: " + SERVICE_NAME);
        log.info("service.instance.count: " + SERVICE_INSTANCE_COUNT);
        log.info("service.port: " + SERVICE_PORT);
        log.info("service.debug.port: " + SERVICE_DEBUG_PORT);
        log.info("service.startup.timeout.seconds: " + SERVICE_STARTUP_TIMEOUT_SECONDS);
        log.info("service.image.tag: " + SERVICE_IMAGE_TAG);
        log.info("service.container.logging.enabled: " + SERVICE_CONTAINER_LOGGING_ENABLED);
        log.info("container.name.prefix: " + CONTAINER_NAME_PREFIX);
        log.info("kafka.enabled: " + KAFKA_ENABLED);
        if (KAFKA_ENABLED) {
            log.info("kafka.confluent.image.version: " + KAFKA_CONFLUENT_IMAGE_VERSION);
            log.info("kafka.container.logging.enabled: " + KAFKA_CONTAINER_LOGGING_ENABLED);
            log.info("kafka.port: " + KAFKA_PORT);
            log.info("kafka.topics: " + KAFKA_TOPICS);
            log.info("kafka.topic.partition.count: " + KAFKA_TOPIC_PARTITION_COUNT);
        }
    }
}

