/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.extension;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerPort;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import dev.lydtech.component.framework.extension.TestContainersConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DockerManager {
    private static final Logger log = LoggerFactory.getLogger(DockerManager.class);

    protected static DockerClient getDockerClient() {
        log.info("Check if services are running");
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost("unix:///var/run/docker.sock").build();
        ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
        return DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
    }

    protected static boolean shouldPerformSetup(DockerClient dockerClient) {
        String mainContainerName = TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + TestContainersConfiguration.SERVICE_NAME + "-0";
        List containers = (List)dockerClient.listContainersCmd().exec();
        boolean mainContainerPresent = containers.stream().anyMatch(x -> Arrays.asList(x.getNames()).contains("/" + mainContainerName));
        boolean testContainersPresent = containers.stream().anyMatch(x -> Arrays.stream(x.getNames()).anyMatch(n -> n.startsWith("/testcontainers-ryuk")));
        log.info("Current container status - main({}): {}, tc: {}", new Object[]{mainContainerName, mainContainerPresent, testContainersPresent});
        return !mainContainerPresent || testContainersPresent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void captureDockerContainerPorts(DockerClient dockerClient) {
        String mainContainerName = TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + TestContainersConfiguration.SERVICE_NAME + "-0";
        log.info("Service container name: " + mainContainerName);
        ListContainersCmd listContainersCmd = dockerClient.listContainersCmd();
        List serviceContainers = (List)listContainersCmd.withNameFilter(Collections.singletonList(mainContainerName)).exec();
        if (serviceContainers.size() <= 0) {
            throw new RuntimeException("Service container not found");
        }
        Integer port = Arrays.stream(((Container)serviceContainers.get(0)).getPorts()).filter(x -> Objects.equals(x.getPrivatePort(), TestContainersConfiguration.SERVICE_PORT)).map(ContainerPort::getPublicPort).findFirst().orElseThrow(() -> new RuntimeException("service port not found"));
        log.info("Service port is " + port);
        System.setProperty("service.port", port.toString());
        if (TestContainersConfiguration.KAFKA_ENABLED) {
            String kafkaContainerName = TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-kafka-0";
            List kafkaContainers = (List)listContainersCmd.withNameFilter(Collections.singletonList(kafkaContainerName)).exec();
            if (kafkaContainers.size() != 1) throw new RuntimeException("Kafka container not found");
            Integer port2 = Arrays.stream(((Container)kafkaContainers.get(0)).getPorts()).filter(x -> Objects.equals(x.getPrivatePort(), TestContainersConfiguration.KAFKA_PORT)).map(ContainerPort::getPublicPort).findFirst().orElseThrow(() -> new RuntimeException("kafka port not found"));
            log.info("Kafka port is " + port2);
            System.setProperty("kafka.port", port2.toString());
            return;
        } else {
            log.info("Kafka broker is not enabled.");
        }
    }
}

