package dev.lydtech.component.framework.kafka;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.serialization.StringSerializer;

/**
 * Factory class for creating Kafka {@link Producer}
 */
@Slf4j
public class KafkaProducerFactory {

    private final String brokerUrl;

    public KafkaProducerFactory(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public Producer<Long, String> createProducer() {
        Properties config = new Properties();
        config.put(ProducerConfig.BOOTSTRAP_SERVERS_CONFIG, brokerUrl);
        config.put(ProducerConfig.KEY_SERIALIZER_CLASS_CONFIG, StringSerializer.class);
        config.put(ProducerConfig.VALUE_SERIALIZER_CLASS_CONFIG, StringSerializer.class);
        log.debug("Kafka producer is created with brokerUrl={}", brokerUrl);
        return new KafkaProducer<>(config);
    }
}
